function adaptKey(key) {
    const keyDisabledSymbols = /[^_0-9A-Za-z]/g;

    if (key[0] === '~') {
        return key.replace('~', '').replace(keyDisabledSymbols, '_');
    }
    return key;
}

function getSpaces(loadJson) {
    const MAX_PAGES = 20;
    let pageNum = 0;
    let spaces = [];
    let hasMore = true;
    let from = 0;

    while (hasMore) {
        if (++pageNum > MAX_PAGES) {
            break;
        }
        let response = loadJson('/rest/api/space', {
            type: 'global',
            start: from.toString(),
            limit: '100'
        });
        console.log('Loaded page ' + pageNum + ' with ' + response.size + ' spaces');
        spaces = spaces.concat(response.results);
        hasMore = response.size >= response.limit;
        from += response.size;
    }

    console.log('Loaded ' + spaces.length + ' spaces');

    const projects = spaces.map(space => ({
        id: space.key, // Key is required to access space's articles, so we treat it as ID
        key: adaptKey(space.key),
        name: space.name
    }));

    // Some exports contain duplicated spaces by unknown reason, so we should filter them out
    const uniqueMap = new Map(projects.map(p => [p.id, p]));
    const withUniqueIds = Array.from(uniqueMap.values());

    const names = new Set();
    withUniqueIds.forEach(project => {
        // Spaces names are not unique
        if (names.has(project.name)) {
            project.name = project.name + '(' + project.key + ')';
        }
        names.add(project.name);
    });

    return withUniqueIds;
}

exports.getSpaces = getSpaces;