/*
 Copyright 2017 JetBrains s.r.o.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

const jiraUtils = require('./utils');

exports.init = context => {
  console.debug('Initializing users directory');
  const csvContent = context.parameters.loadValue('usersDirectory');
  const directory = {
    initialized: false,
    users: {}
  };
  jiraUtils.setObject(context, 'usersDirectory', directory)
  if (!csvContent) {
    console.debug('No csv content found, returning an empty directory');
    return directory;
  } else {
    directory.initialized = true;
  }
  const lines = csvContent.split('\n');
  let firstMeaningfulColumn = 0;
  console.debug('No csv content found, returning an empty directory');
  lines.forEach(function(line) {
    if (line.length === 0) {
      return;
    }
    var parts = line.split(',');
    if (parts[0] === 'id') { // it's a first line of a properly exported file
      return;
    } else if (parts[0] === 'groupname') { // first line of a not so properly formatted file
      firstMeaningfulColumn = 1;
      return;
    }
    if (parts.length < 4) {
      throw "Incorrect export-users.csv line format, at least 4 elements (accountId, email, display name, active/inactive). Found: " + line;
    }
    const userRepresentation = {
      accountId: parts[firstMeaningfulColumn],
      displayName: parts[firstMeaningfulColumn + 1],
      email: parts[firstMeaningfulColumn + 2],
      active: parts[firstMeaningfulColumn + 3] === 'Yes'
    };
    directory.users[userRepresentation.accountId] = userRepresentation;
  });
  return directory;
}

exports.fillFromDirectory = (context, original) => {
  const isCloud = jiraUtils.getObject(context, 'isCloud');
  if (!isCloud) {
    console.trace('Not a cloud, don\'t try filling a user from users directory');
    return;
  }
  const accountId = original.accountId;
  if (!accountId) {
    console.debug('Empty account id passed');
    return null;
  }
  const userDetails = jiraUtils.getObject(context, 'usersDirectory').users[accountId];
  if (userDetails) {
    original.name = userDetails.displayName; // because there's no name (login) available in the file
    original.emailAddress = userDetails.email;
    original.displayName = userDetails.displayName;
    original.active = userDetails.active;
  }
}
