/*
 Copyright 2017 JetBrains s.r.o.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

exports.permissionKeys = {
  'BROWSE' : ['BROWSE', 'BROWSE_PROJECTS'],
  'CREATE_ISSUE': ['CREATE_ISSUE', 'CREATE_ISSUES'],
  'PROJECT_ADMIN': ['PROJECT_ADMIN', 'ADMINISTER_PROJECTS'],
  'VIEW_VOTERS_AND_WATCHERS': ['VIEW_VOTERS_AND_WATCHERS'],
  'MANAGE_WATCHER_LIST': ['MANAGE_WATCHER_LIST', 'MANAGE_WATCHERS']
};

exports.getOrCreateObject = function(context, name, constructor) {
  let value = context.getObject(name);
  if (!value) {
    value = constructor();
    context.setObject(name, value);
  }
  return value;
};

exports.getObject = function(context, key) {
  return context.getObject(key)
};

exports.setObject = function(context, key, object) {
  return context.setObject(key, object)
};

exports.copyProperties = function(src, dest, propertyNames) {
  (propertyNames || Object.getOwnPropertyNames(src)).forEach(name => dest[name] = src[name]);
  return dest;
};

const toJsonDebug = function(object, limit, restrictions, level, showLevelAndLimit) {
  const thisLevel = level || 0;
  const nextLevel = thisLevel + 1;
  const res = restrictions || {};
  if (thisLevel < limit && typeof object == 'object' && object !== null) {
    const tab = '  ';
    const indentOld = Array(nextLevel).join(tab);
    const indentNew = indentOld + tab;
    if (Array.isArray(object)) {
      return '[' + '\n' + indentNew +
          object.map((item, index) => {
            return index + ': '
                + toJsonDebug(item, limit, restrictions, nextLevel, showLevelAndLimit);
          }).join('\n' + indentNew)
          + '\n' + indentOld + ']';
    } else {
      return '{' + '\n' + indentNew
          + Object.keys(object).map(key => {
            const overriddenLimit = (key in res) ? (res[key] + nextLevel) : limit;
            return showLevelAndLimit ? ('[' + nextLevel + '-' + overriddenLimit + '] ') : ''
                + key + ' : '
                + toJsonDebug(object[key], overriddenLimit, restrictions, nextLevel, showLevelAndLimit);
          }).join('\n' + indentNew)
          + '\n' + indentOld + '}';
    }
  } else {
    return object;
  }
};

exports.toJsonDebug = toJsonDebug;
