const http = require('@jetbrains/youtrack-scripting-api/http');

// needed to be global to be able to add as an auth header value
let tokenOrPassword;

function makeBasicConnection(context) {
    const params = context.parameters;

    const url = params.loadValue('url');
    const sslKeyName = params.loadValue('sslKeyName');
    const login = params.loadValue('login');
    tokenOrPassword = params.loadValue('password');

    return new http.Connection(url, sslKeyName)
        .basicAuth(login, tokenOrPassword);
}

function makeHttpConnection(context) {
    return makeBasicConnection(context)
        .addHeader('Accept', 'application/json, */*')
        .addHeader('Content-Type', 'application/json')
        .addHeader('X-Redmine-API-Key', tokenOrPassword);
}

function loadJsonFactory(connection) {
    return function loadJson(uri, queryParams) {
        const result = connection.getSync(uri, queryParams);
        if (!result.isSuccess) {
            throw 'Failed to load data from ' + uri + ' code ' + result.code;
        } else {
            return JSON.parse(result.response);
        }
    }
}

module.exports = {
    makeHttpConnection: makeHttpConnection,
    loadJsonFactory: loadJsonFactory,
}