const toPeriod = require('@jetbrains/youtrack-scripting-api/date-time').toPeriod;

const setVisible = (isPrivate, project) => {
    return isPrivate ? [project + ' Team'] : null
};

exports.setVisible = setVisible;

exports.cleanKeyName = key => {
    return key.replace(/[^\w\s]/g, '')
};

exports.convertType = type => {
    console.log('converting from Redmine type: ' + type);
    switch (type) {
        case 'int':
            return 'integer';
        case 'status':
            return 'state';
        case 'float':
            return 'float';
        case 'list':
        case 'enumeration':
            return 'enum';
        case 'text':
            return 'text';
        case 'date':
            return 'date';
        case 'version':
            return 'version'
        default:
            return 'string';
    }
}

exports.convertRelations = type => {
    console.log('Converting relation: ' + type);
    switch (type) {
        case 'relates':
            return 'relates to';
        case 'copied_to':
            return 'copied to';
        default:
            return type;

    }
}

const floatConverter = value => {
    return toPeriod(value * 3.6e+6).toString();
}

exports.floatConverter = floatConverter;

const notNull = value => value !== null;

//this map and method are needed for history conversion, as Redmine returns ids/names of some of the fields, not values
const fieldsMap = {};


exports.toFieldMap = (arrayOfFields, arrayOfNames) => {
    arrayOfFields.forEach((el, i) => {
        //saving users
        if (i === 2) fieldsMap['users'] = el;
        if (!fieldsMap.hasOwnProperty(arrayOfNames[i])) fieldsMap[arrayOfNames[i]] = {};

        //checking if a field has values in it and creating map from them
        if (el.length) el.forEach(e => {
            if (!fieldsMap[arrayOfNames[i]].hasOwnProperty(e.id)) fieldsMap[arrayOfNames[i]][e.id] = {};
            fieldsMap[arrayOfNames[i]][e.id] = e;
        });
    })
}

//name property is used for fields that rely on itnam
exports.convertHistoryField = (element, issueData) => {
    console.log('Converting history item: ' + element.name);
    console.log('Current Element: ', JSON.stringify(element));
    console.log('Fields Map: ', JSON.stringify(fieldsMap));
    switch (element.name) {
        case 'tracker_id':
            return {
                name: 'Type',
                type: 'enum',
                old: fieldsMap[element.name][element.old_value].name,
                new: fieldsMap[element.name][element.new_value].name
            }
        case 'category_id':
            return {
                name: 'Subsystem',
                type: 'ownedField',
                old: notNull(element.old_value) ? fieldsMap[element.name][element.old_value].name : '',
                new: notNull(element.new_value) ? fieldsMap[element.name][element.new_value].name : ''
            }
            //currently not implemented
       /* case 'project_id':
            return {
                name: 'Project',
                type: 'string',
                old: fieldsMap[element.name][element.old_value].name,
                new: fieldsMap[element.name][element.new_value].name
            }*/
        case 'status_id':
            return {
                name: 'State',
                type: 'state',
                old: element.old_value ? fieldsMap[element.name][element.old_value].name : issueData.status.name,
                new: element.new_value ? fieldsMap[element.name][element.new_value].name : issueData.status.name
            }
        case 'estimated_hours':
            return {
                name: 'Estimation',
                type: 'period',
                old: element.old_value ? floatConverter(element.old_value) : '',
                new: element.new_value ? floatConverter(element.new_value): ''
            }
        case 'priority_id':
            return {
                name: 'Priority',
                type: 'enum',
                old: element.old_value ? element.old_value + '' : '',
                new: element.new_value ? element.new_value + '' : ''
            }
        case 'subject':
            return {
                name: 'summary',
                type: 'string',
                old: element.old_value,
                new: element.new_value
            }
        case 'description':
            return {
                name: 'description',
                type: 'text',
                old: element.old_value ? element.old_value + '' : '',
                new: element.new_value ? element.new_value + '' : ''
            }
        case 'due_date':
            return {
                name: 'Due Date',
                type: 'date',
                old: element.old_value,
                new: element.new_value
            }
        case 'start_date':
            return {
                name: 'Start Date',
                type: 'date',
                old: element.old_value,
                new: element.new_value
            }
        case 'is_private':
            return {
                name: 'visibleToGroups',
                type: 'group',
                old: element.old_value === '0' ? null : setVisible(true, issueData.project.name)[0].name,
                new: element.new_value === '0' ? null: setVisible(true, issueData.project.name)[0].name,
            }
        case 'assigned_to_id':
            return {
                name: 'assignee',
                type: 'user',
                old: notNull(element.old_value) ? fieldsMap['users'][element.old_value].login : '',
                new: notNull(element.new_value) ? fieldsMap['users'][element.new_value].login : '',
            }
        case 'fixed_version_id':
            return {
                name: 'Fix versions',
                type: 'version',
                old: notNull(element.old_value) ? fieldsMap[element.name][element.old_value].name : '',
                new: notNull(element.new_value) ? fieldsMap[element.name][element.new_value].name : ''
            }
        case 'done_ratio':
            console.log('got done_ratio, skipping...');
            return {
                name: 'Done ratio',
                type: 'string',
                old: element.old_value,
                new: element.new_value,
            }
    }

}

exports.convertHistoryCfField = (element) => {
    const thisName = fieldsMap[element.property][element.name].name;
    const thisType = fieldsMap[element.property][element.name].type;
    console.log('Converting history with CF item: ' + thisName);
    console.log('Current Element: ', JSON.stringify(element));
    console.log('Fields Map: ', JSON.stringify(fieldsMap));

    return {
        name: thisName,
        type: thisType,
        old: thisType !== 'string' && notNull(element.old_value) && Array.isArray(thisName.values) && thisName.values.length ? thisName.values.filter((el, i) => +element.old_value === i)[0].name : notNull(element.old_value) ? element.old_value + '' : '',
        new: thisType !== 'string' && notNull(element.new_value) && Array.isArray(thisName.values) && thisName.values.length ? thisName.values.filter((el, i) => +element.new_value === i)[0].name : notNull(element.new_value) ? element.new_value + '' : '',
    }
}


