/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.jenkins.impl.api;

import com.offbytwo.jenkins.client.JenkinsHttpClient;
import java.net.URI;
import java.util.Map;
import java.util.WeakHashMap;
import jetbrains.youtrack.core.ssl.SSLContextFactoryKt;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.integration.jenkins.impl.api.JenkinsClientFactoryKt;
import jetbrains.youtrack.integration.jenkins.impl.api.JenkinsRestClient;
import jetbrains.youtrack.integration.jenkins.impl.api.LoggingJenkinsHttpClientAdapter;
import jetbrains.youtrack.integration.jenkins.persistent.XdJenkinsServer;
import jetbrains.youtrack.service.ConnectionToRemoteHostNotAllowedException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J8\u0010\u0010\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J:\u0010\u0013\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/integration/jenkins/impl/api/JenkinsClientFactory;", "", "()V", "clients", "Ljava/util/WeakHashMap;", "", "Ljetbrains/youtrack/integration/jenkins/impl/api/JenkinsRestClient;", "createJenkinsServer", "url", "login", "password", "readTimeout", "", "socketTimeout", "key", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "get", "server", "Ljetbrains/youtrack/integration/jenkins/persistent/XdJenkinsServer;", "getKey", "youtrack-jenkins-integration"})
public final class JenkinsClientFactory {
    private final WeakHashMap<String, JenkinsRestClient> clients = new WeakHashMap();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized JenkinsRestClient get(@NotNull XdJenkinsServer server) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)server), (String)"server");
        Map map = this.clients;
        String key$iv = this.getKey(server);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            JenkinsRestClient answer$iv = this.createJenkinsServer(server.getUrl(), server.getLogin(), server.getPassword(), server.getReadTimeOut(), server.getSocketTimeOut(), server.getSslKey());
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"clients.getOrPut(getKey(\u2026 server.sslKey)\n        }");
        return (JenkinsRestClient)((Object)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized JenkinsRestClient get(@NotNull String url, @NotNull String login, @NotNull String password2, int readTimeout, int socketTimeout, @Nullable XdStorageEntry key) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
        Intrinsics.checkParameterIsNotNull((Object)password2, (String)"password");
        Map map = this.clients;
        String key$iv = this.getKey(url, login, password2, readTimeout, socketTimeout, key);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            JenkinsRestClient answer$iv = this.createJenkinsServer(url, login, password2, readTimeout, socketTimeout, key);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"clients.getOrPut(getKey(\u2026etTimeout, key)\n        }");
        return (JenkinsRestClient)((Object)object);
    }

    private final String getKey(XdJenkinsServer server) {
        return this.getKey(server.getUrl(), server.getLogin(), server.getPassword(), server.getReadTimeOut(), server.getSocketTimeOut(), server.getSslKey());
    }

    private final String getKey(String url, String login, String password2, int readTimeout, int socketTimeout, XdStorageEntry key) {
        XdStorageEntry xdStorageEntry = key;
        return url + ' ' + login + ' ' + password2 + ' ' + readTimeout + ' ' + socketTimeout + ' ' + (xdStorageEntry != null ? xdStorageEntry.getKeystoreAlias() : null);
    }

    private final JenkinsRestClient createJenkinsServer(String url, String login, String password2, int readTimeout, int socketTimeout, XdStorageEntry key) {
        if (!JenkinsClientFactoryKt.getOutboundConnectionManager().isConnectionAllowed(url)) {
            throw (Throwable)new ConnectionToRemoteHostNotAllowedException("Connection to " + url + " is not allowed");
        }
        HttpClientBuilder builder = HttpClientBuilder.create().setSSLContext(SSLContextFactoryKt.createSSLContext((XdStorageEntry)key)).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(readTimeout * 1000).setConnectionRequestTimeout(readTimeout * 1000).setSocketTimeout(socketTimeout * 1000).build());
        JenkinsHttpClient client = new JenkinsHttpClient(new URI(url), builder, login, password2);
        return new JenkinsRestClient(new LoggingJenkinsHttpClientAdapter(client));
    }
}

