/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.jenkins.impl.api;

import com.google.common.base.Optional;
import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.client.JenkinsHttpConnection;
import com.offbytwo.jenkins.client.util.EncodingUtils;
import com.offbytwo.jenkins.client.util.UrlUtils;
import com.offbytwo.jenkins.helper.JenkinsVersion;
import com.offbytwo.jenkins.helper.Range;
import com.offbytwo.jenkins.model.BaseModel;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.BuildWithDetails;
import com.offbytwo.jenkins.model.FolderJob;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.JobWithDetails;
import com.offbytwo.jenkins.model.MainView;
import com.offbytwo.jenkins.model.Plugin;
import com.offbytwo.jenkins.model.PluginManager;
import com.offbytwo.jenkins.model.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.integration.jenkins.impl.api.JenkinsRestClient;
import jetbrains.youtrack.integration.jenkins.impl.api.JobNotFoundException;
import jetbrains.youtrack.integration.jenkins.impl.api.ViewNotFoundException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J(\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010\u001c\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\b\u0010\u001e\u001a\u0004\u0018\u00010\u0006J\f\u0010\u001f\u001a\u00020 *\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Ljetbrains/youtrack/integration/jenkins/impl/api/JenkinsRestClient;", "Lcom/offbytwo/jenkins/JenkinsServer;", "restClient", "Lcom/offbytwo/jenkins/client/JenkinsHttpConnection;", "(Lcom/offbytwo/jenkins/client/JenkinsHttpConnection;)V", "id", "", "Lcom/offbytwo/jenkins/model/Job;", "getId", "(Lcom/offbytwo/jenkins/model/Job;)Ljava/lang/String;", "flattenJobsTree", "", "root", "getBasicViews", "Lcom/offbytwo/jenkins/model/View;", "getBuilds", "Lcom/offbytwo/jenkins/model/Build;", "job", "pendingBuildRange", "Lcom/offbytwo/jenkins/helper/Range;", "getJob", "Lcom/offbytwo/jenkins/model/JobWithDetails;", "folder", "Lcom/offbytwo/jenkins/model/FolderJob;", "jobName", "getJobs", "", "view", "getView", "name", "testConnection", "isSupportedJenkinsVersion", "", "Lcom/offbytwo/jenkins/helper/JenkinsVersion;", "Companion", "youtrack-jenkins-integration"})
public final class JenkinsRestClient
extends JenkinsServer {
    private final JenkinsHttpConnection restClient;
    @NotNull
    public static final String FAILED_CONNECTION_VERSION_PLACEHOLDER = "UNKNOWN";
    @NotNull
    public static final String UNAUTHORIZED_VERSION_PLACEHOLDER = "";
    @NotNull
    public static final String MINIMUM_COMPATIBLE_VERSION_1X = "1.651.3";
    @NotNull
    public static final String MINIMUM_COMPATIBLE_VERSION_2X = "2.15";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String testConnection() {
        try {
            Object v4;
            block6: {
                if (Intrinsics.areEqual((Object)this.getVersion().toString(), (Object)FAILED_CONNECTION_VERSION_PLACEHOLDER)) {
                    return BeansKt.getLocalizer().localizedMsg("JenkinsClient.connection_failed", new Object[0]);
                }
                if (Intrinsics.areEqual((Object)this.getVersion().toString(), (Object)UNAUTHORIZED_VERSION_PLACEHOLDER)) {
                    return BeansKt.getLocalizer().localizedMsg("JenkinsClient.unauthorized", new Object[0]);
                }
                JenkinsVersion jenkinsVersion = this.getVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)jenkinsVersion, (String)"version");
                if (!this.isSupportedJenkinsVersion(jenkinsVersion)) {
                    return BeansKt.getLocalizer().localizedMsg("JenkinsClient.incompatible_version", new Object[]{this.getVersion().toString(), MINIMUM_COMPATIBLE_VERSION_1X, MINIMUM_COMPATIBLE_VERSION_2X});
                }
                PluginManager pluginManager = this.getPluginManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)pluginManager, (String)"pluginManager");
                List list = pluginManager.getPlugins();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"pluginManager.plugins");
                Iterable iterable = list;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    Plugin it = (Plugin)t;
                    boolean bl3 = false;
                    Plugin plugin = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)plugin, (String)"it");
                    if (!Intrinsics.areEqual((Object)plugin.getShortName(), (Object)"last-changes")) continue;
                    v4 = t;
                    break block6;
                }
                v4 = null;
            }
            Plugin changesPlugin = v4;
            return changesPlugin == null ? BeansKt.getLocalizer().localizedMsg("JenkinsClient.no_last_changes_plugin", new Object[0]) : (!changesPlugin.isActive() ? BeansKt.getLocalizer().localizedMsg("JenkinsClient.last_changes_plugin_disabled", new Object[0]) : null);
        }
        catch (Exception e) {
            Companion.getLogger().warn("Jenkins server connection test failed", (Throwable)e);
            return BeansKt.getLocalizer().localizedMsg("JenkinsClient.connection_test_failed", new Object[]{e.getMessage()});
        }
    }

    private final boolean isSupportedJenkinsVersion(@NotNull JenkinsVersion $this$isSupportedJenkinsVersion) {
        boolean result;
        boolean bl = result = $this$isSupportedJenkinsVersion.isGreaterOrEqual(MINIMUM_COMPATIBLE_VERSION_1X) && $this$isSupportedJenkinsVersion.isLessThan("2.0") || $this$isSupportedJenkinsVersion.isGreaterOrEqual(MINIMUM_COMPATIBLE_VERSION_2X);
        if (result) {
            Companion.getLogger().debug("Connected to the compatible Jenkins version " + $this$isSupportedJenkinsVersion);
        } else {
            Companion.getLogger().warn("Connected to an incompatible Jenkins version " + $this$isSupportedJenkinsVersion);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<View> getBasicViews() {
        void $this$mapTo$iv$iv;
        List views;
        BaseModel baseModel = this.restClient.get("/?tree=views[name,url]", MainView.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)baseModel, (String)"restClient.get(\"/?tree=v\u2026]\", MainView::class.java)");
        List list = views = ((MainView)baseModel).getViews();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"views");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            View view = (View)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            v2.setClient(this.restClient);
            void var12_12 = it;
            collection.add(var12_12);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, Job> getJobs(@Nullable FolderJob folder, @Nullable String view) {
        void $this$associateByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Job it;
        Iterable $this$filterTo$iv$iv;
        String path = UrlUtils.toBaseUrl((FolderJob)folder);
        Class<MainView> viewClass = MainView.class;
        if (view != null) {
            path = path + "view/" + EncodingUtils.encode((String)view) + "/";
            viewClass = View.class;
        }
        BaseModel baseModel = this.restClient.get(path, viewClass);
        Intrinsics.checkExpressionValueIsNotNull((Object)baseModel, (String)"restClient.get(path, viewClass)");
        List list = ((MainView)baseModel).getJobs();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"restClient.get(path, viewClass).jobs");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Job)element$iv$iv;
            boolean bl = false;
            Job job = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)job, (String)"it");
            if (!(job.getName() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Job)element$iv$iv;
            boolean bl = false;
            Job job = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)job, (String)"it");
            Iterable list$iv$iv = this.flattenJobsTree(job);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List jobs = (List)destination$iv$iv;
        Iterable $this$associateBy$iv = jobs;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            Job bl = (Job)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl2 = false;
            String string = this.getId((Job)it2);
            map.put(string, element$iv$iv);
        }
        return destination$iv$iv2;
    }

    @NotNull
    public JobWithDetails getJob(@Nullable FolderJob folder, @NotNull String jobName) {
        Intrinsics.checkParameterIsNotNull((Object)jobName, (String)"jobName");
        JobWithDetails jobWithDetails = super.getJob(folder, jobName);
        if (jobWithDetails == null) {
            throw (Throwable)((Object)new JobNotFoundException(jobName));
        }
        return jobWithDetails;
    }

    @NotNull
    public View getView(@Nullable FolderJob folder, @NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        View view = super.getView(folder, name2);
        if (view == null) {
            throw (Throwable)((Object)new ViewNotFoundException(name2));
        }
        return view;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Build> getBuilds(@NotNull String job, @NotNull Range pendingBuildRange) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        Intrinsics.checkParameterIsNotNull((Object)pendingBuildRange, (String)"pendingBuildRange");
        List list = this.getJob(job).getAllBuilds(pendingBuildRange);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"getJob(job).getAllBuilds(pendingBuildRange)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Build build = (Build)element$iv$iv;
            boolean bl = false;
            BuildWithDetails buildWithDetails = build.details();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildWithDetails, (String)"build.details()");
            if (!(!buildWithDetails.isBuilding())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Job> flattenJobsTree(Job root) {
        List list;
        Optional maybeFolder;
        Optional optional = maybeFolder = this.getFolderJob(root);
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"maybeFolder");
        if (optional.isPresent()) {
            void $this$flatMapTo$iv$iv;
            Object object = maybeFolder.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"maybeFolder.get()");
            Map map = ((FolderJob)object).getJobs();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"maybeFolder.get().jobs");
            Map $this$flatMap$iv = map;
            boolean $i$f$flatMap = false;
            Map map2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            void var8_8 = $this$flatMapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var8_8.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                Object v = it.getValue();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
                Iterable list$iv$iv = this.flattenJobsTree((Job)v);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOf((Object)root);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final String getId(@NotNull Job $this$id) {
        String string;
        block2: {
            String string2 = $this$id.getUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url");
            String $this$dropLastWhile$iv = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)string2, (String[])new String[]{"/job/"}, (boolean)false, (int)0, (int)6, null), (int)1), (CharSequence)"/", null, null, (int)0, null, (Function1)id.1.INSTANCE, (int)30, null);
            boolean $i$f$dropLastWhile = false;
            int n = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv);
            boolean bl = false;
            while (n >= 0) {
                void index$iv;
                char it = $this$dropLastWhile$iv.charAt((int)index$iv);
                boolean bl2 = false;
                if (!(it == '/')) {
                    String string3 = $this$dropLastWhile$iv;
                    int n2 = 0;
                    void var8_9 = index$iv + true;
                    boolean bl3 = false;
                    String string4 = string3.substring(n2, (int)var8_9);
                    string = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    break block2;
                }
                --index$iv;
            }
            string = UNAUTHORIZED_VERSION_PLACEHOLDER;
        }
        return string;
    }

    public JenkinsRestClient(@NotNull JenkinsHttpConnection restClient2) {
        Intrinsics.checkParameterIsNotNull((Object)restClient2, (String)"restClient");
        super(restClient2);
        this.restClient = restClient2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/integration/jenkins/impl/api/JenkinsRestClient$Companion;", "Lmu/KLogging;", "()V", "FAILED_CONNECTION_VERSION_PLACEHOLDER", "", "MINIMUM_COMPATIBLE_VERSION_1X", "MINIMUM_COMPATIBLE_VERSION_2X", "UNAUTHORIZED_VERSION_PLACEHOLDER", "youtrack-jenkins-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

