/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jira.plugin;

import jetbrains.charisma.persistent.ExternalIssueLinksProvider;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.imports.persistence.IntegratedEntitiesKt;
import jetbrains.youtrack.persistent.XdExternalProjectDocumentReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/jira/plugin/JiraIssueLinksProvider;", "Ljetbrains/charisma/persistent/ExternalIssueLinksProvider;", "()V", "name", "", "getName", "()Ljava/lang/String;", "accept", "", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "getCommentsKey", "getCommentsUrl", "getHistoryKey", "getHistoryUrl", "getIssueKey", "getIssueUrl", "suffix", "relevantExternalRef", "Ljetbrains/youtrack/persistent/XdExternalProjectDocumentReference;", "youtrack-jira-import"})
public final class JiraIssueLinksProvider
implements ExternalIssueLinksProvider {
    @NotNull
    private final String name = "JIRA";

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean accept(@NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        return this.relevantExternalRef(issue) != null;
    }

    private final XdExternalProjectDocumentReference relevantExternalRef(XdIssue issue) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = XdQueryKt.asSequence((XdQuery)((XdQuery)IntegratedEntitiesKt.getExternalReferences((XdIssue)issue)));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                XdExternalProjectDocumentReference it = (XdExternalProjectDocumentReference)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIntegration().getPluginName(), (Object)"@jetbrains/youtrack-import-plugin")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public String getIssueUrl(@NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        return this.getIssueUrl(issue, "");
    }

    private final String getIssueUrl(XdIssue issue, String suffix) {
        XdExternalProjectDocumentReference xdExternalProjectDocumentReference = this.relevantExternalRef(issue);
        if (xdExternalProjectDocumentReference == null || (xdExternalProjectDocumentReference = xdExternalProjectDocumentReference.getIntegration()) == null) {
            return null;
        }
        XdExternalProjectDocumentReference integration = xdExternalProjectDocumentReference;
        String string = integration.getParameter("url");
        String jiraUrl = string != null ? StringsKt.removeSuffix((String)string, (CharSequence)"/") : null;
        return jiraUrl + "/browse/" + this.getIssueKey(issue) + "?disableRedirect" + suffix;
    }

    @Nullable
    public String getIssueKey(@NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        XdExternalProjectDocumentReference xdExternalProjectDocumentReference = this.relevantExternalRef(issue);
        return xdExternalProjectDocumentReference != null ? xdExternalProjectDocumentReference.getVisibleId() : null;
    }

    @Nullable
    public String getCommentsUrl(@NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        return this.getIssueUrl(issue, "&page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel");
    }

    @NotNull
    public String getCommentsKey(@NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        return BeansKt.getLocalizer().localizedMsgInServerLocale("JiraIssueLinksProvider.comments", new Object[0]);
    }

    @Nullable
    public String getHistoryUrl(@NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        return this.getIssueUrl(issue, "&page=com.atlassian.jira.plugin.system.issuetabpanels:changehistory-tabpanel");
    }

    @NotNull
    public String getHistoryKey(@NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        return BeansKt.getLocalizer().localizedMsgInServerLocale("JiraIssueLinksProvider.history", new Object[0]);
    }
}

