/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.localization.rest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import jetbrains.mps.internationalization.runtime.LocaleEntry;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.localization.ClientSideTranslationPart;
import jetbrains.youtrack.localization.TranslationsAware;
import jetbrains.youtrack.localization.rest.CustomTranslationsResource;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/translations")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J-\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0011\u001a\u00020\f2\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/localization/rest/CustomTranslationsResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "translationsAware", "Ljetbrains/youtrack/localization/TranslationsAware;", "getTranslationsAware", "()Ljetbrains/youtrack/localization/TranslationsAware;", "getCustomTranslationInputStream", "Ljava/io/InputStream;", "locale", "Ljava/util/Locale;", "lang", "", "translations", "Ljetbrains/youtrack/localization/ClientSideTranslationPart;", "getLangPartBuildNumber", "Ljavax/ws/rs/core/Response;", "part", "asJS", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "Companion", "youtrack-localization"})
public class CustomTranslationsResource
implements Resource {
    @NotNull
    public static final String JS_TYPE = "application/javascript";
    @NotNull
    public static final String JS_CODE = "window.userLangDict.translations=";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final TranslationsAware getTranslationsAware() {
        String name$iv = "jsonTranslationAware";
        boolean $i$f$getBean = false;
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.localization.TranslationsAware");
        }
        return (TranslationsAware)object;
    }

    @GET
    @Path(value="/{lang}/{part}/{buildNumber}")
    @Produces(value={"application/javascript;charset=UTF-8", "application/json;charset=UTF-8"})
    @NotNull
    public final Response getLangPartBuildNumber(@PathParam(value="lang") @NotNull String lang, @PathParam(value="part") @NotNull String part, @QueryParam(value="asJS") @Nullable Boolean asJS) {
        InputStream inputStream2;
        Object v4;
        ClientSideTranslationPart translations;
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
            Intrinsics.checkParameterIsNotNull((Object)part, (String)"part");
            String string = part;
            boolean bl = false;
            String string2 = string.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
            translations = ClientSideTranslationPart.valueOf(string2);
            Iterable iterable = BeansKt.getLocalizer().getSupportedLocales();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"localizer.supportedLocales");
            Iterable $this$firstOrNull$iv = iterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LocaleEntry it = (LocaleEntry)element$iv;
                boolean bl2 = false;
                LocaleEntry localeEntry = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)localeEntry, (String)"it");
                String string3 = localeEntry.getLocale().toLanguageTag();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.locale.toLanguageTag()");
                if (!StringsKt.contains((CharSequence)string3, (CharSequence)lang, (boolean)true)) continue;
                v4 = element$iv;
                break block5;
            }
            v4 = null;
        }
        LocaleEntry localeEntry = v4;
        if (localeEntry == null) {
            throw (Throwable)new NotFoundException("Cannot find translation for " + lang + " language.");
        }
        LocaleEntry targetLocale = localeEntry;
        Iterable iterable = BeansKt.getLocalizer().getCustomLocales();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"localizer.customLocales");
        boolean localeIsCustom = CollectionsKt.contains((Iterable)iterable, (Object)targetLocale);
        CacheControl cc = new CacheControl();
        cc.setMaxAge(localeIsCustom ? 36000 : 604800);
        cc.setPrivate(false);
        try {
            InputStream inputStream3 = this.getTranslationsAware().getInputStreamForLanguage(lang);
            if (inputStream3 == null) {
                Locale locale = targetLocale.getLocale();
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"targetLocale.locale");
                inputStream3 = this.getCustomTranslationInputStream(locale, lang, translations);
            }
            inputStream2 = inputStream3;
        }
        catch (Throwable e) {
            Companion.getLogger().error(e, (Function0)new Function0<String>(lang){
                final /* synthetic */ String $lang;

                @NotNull
                public final String invoke() {
                    return "Failed to open stream to translations for language " + this.$lang;
                }
                {
                    this.$lang = string;
                    super(0);
                }
            });
            throw (Throwable)new NotFoundException("Cannot find translation for " + lang + " language.", e);
        }
        InputStream inputStream4 = inputStream2;
        Response response = Response.ok((Object)new StreamingOutput(asJS, inputStream4, lang){
            final /* synthetic */ Boolean $asJS;
            final /* synthetic */ InputStream $inputStream;
            final /* synthetic */ String $lang;

            public final void write(OutputStream out) {
                try {
                    if (Intrinsics.areEqual((Object)this.$asJS, (Object)true)) {
                        byte[] byArray;
                        String string = "window.userLangDict.translations=";
                        Charset charset = Charsets.UTF_8;
                        boolean bl = false;
                        String string2 = string;
                        boolean bl2 = false;
                        byte[] byArray2 = string2.getBytes(charset);
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                        byte[] byArray3 = byArray = byArray2;
                        IOUtils.copy((InputStream)new ByteArrayInputStream(byArray3), (OutputStream)out);
                    }
                    IOUtils.copyLarge((InputStream)this.$inputStream, (OutputStream)out);
                    this.$inputStream.close();
                    out.flush();
                }
                catch (Throwable e) {
                    CustomTranslationsResource.Companion.getLogger().error(e, (Function0)new Function0<String>(this){
                        final /* synthetic */ getLangPartBuildNumber.1 this$0;

                        @NotNull
                        public final String invoke() {
                            return "Failed to copy stream from translations for language " + this.this$0.$lang;
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                    throw (Throwable)new NotFoundException("Cannot load translation for " + this.$lang + " language.", e);
                }
            }
            {
                this.$asJS = bl;
                this.$inputStream = inputStream2;
                this.$lang = string;
            }
        }).cacheControl(cc).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(StreamingOut\u2026.cacheControl(cc).build()");
        return response;
    }

    private final InputStream getCustomTranslationInputStream(Locale locale, String lang, ClientSideTranslationPart translations) {
        File folder = new File(System.getProperty("jetbrains.mps.webr.i18n.custom-translations"));
        String string = locale.toLanguageTag();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"locale.toLanguageTag()");
        File targetJSON = new File(new File(folder, StringsKt.replace$default((String)string, (String)"-", (String)"_", (boolean)false, (int)4, null)), translations.getFileName());
        if (!targetJSON.exists()) {
            throw (Throwable)new NotFoundException("Cannot find translation for " + lang + " language.");
        }
        File file = targetJSON;
        boolean bl = false;
        return new FileInputStream(file);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/localization/rest/CustomTranslationsResource$Companion;", "Lmu/KLogging;", "()V", "JS_CODE", "", "JS_TYPE", "youtrack-localization"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

