<#ftl attributes={"description":"Overview of the issue update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign priority = issue.Priority>
    <#assign isShowStopper = (!priority?is_enumerable && priority == "Show-stopper")>
    <#if change.hasEvent("CREATED")>
        <#if (!priority?is_enumerable && priority == "Show-stopper")>
            <@l10n>New show-stopper was reported by ${issue.reporter.getVisibleName()}:</@l10n>
        <#else>
            <@l10n>New issue was reported by ${issue.reporter.getVisibleName()}:</@l10n>
        </#if>
    <#elseif last_notification?has_content && last_notification>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("PROJECT")>
            <#if from == to>
                <@l10n>
                    On ${time}, you moved an issue to a project in which you don't have permission to read issues.
                </@l10n>
            <#else>
                <@l10n>
                    On ${time}, ${from.getVisibleName()} moved an issue to a project in which you don't have permission to read issues.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("PERMITTED")>
            <#if from == to>
                <@l10n>
                    On ${time}, you restricted the visibility of an issue to a group of users that you don't belong to.
                </@l10n>
            <#else>
                <@l10n>
                    On ${time}, ${from.getVisibleName()} restricted the visibility of an issue to a group of users that you don't belong to.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("DELETED")>
            <#if from == to>
                <@l10n>
                    On ${time}, you deleted an issue in the ${issue.project.name} project.
                </@l10n>
            <#else>
                <@l10n>
                    On ${time}, ${from.getVisibleName()} deleted an issue in the ${issue.project.name} project.
                </@l10n>
            </#if>
        <#else>
            <@l10n>
                On ${time}, ${from.getVisibleName()} restricted access to an issue.
            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <#if isShowStopper>
                <@l10n>You changed show-stopper:</@l10n>
            <#else>
                <@l10n>You changed issue:</@l10n>
            </#if>
        <#else>
            <#if isShowStopper>
                <@l10n>User ${from.getVisibleName()} changed show-stopper:</@l10n>
            <#else>
                <@l10n>User ${from.getVisibleName()} changed issue:</@l10n>
            </#if>
        </#if>
    </#if>
</p>
</#escape>