<#ftl attributes={"description":"Overview of the article update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text} padding: 12px 16px;">
        <#assign bold = "font-weight: bold;">
        <#assign projectName = article.project.name>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("ARTICLE_CREATED")>
                <@l10n>
                    Am ${time} hat <span style="${bold}">${from.getVisibleName()}</span> einen Artikel zum Projekt <span style="${bold}">${projectName}</span> hinzugefügt.
                </@l10n>
        <#elseif last_notification?has_content && last_notification>
            <#if change.hasEvent("ARTICLE_PROJECT")>
                <#if from==to>
                    <@l10n> Am ${time} haben Sie einen Artikel in ein Projekt verschoben, in dem Sie keine Artikel-Leseberechtigung haben. </@l10n>
                <#else>
                    <@l10n> Am ${time} hat <span style="${bold}">${from.getVisibleName()}</span> einen Artikel in ein Projekt verschoben, in dem Sie keine Artikel-Leseberechtigung haben. </@l10n>
                </#if>
            <#elseif change.hasEvent("ARTICLE_VISIBILITY")>
                <#if from==to>
                    <@l10n> Am ${time} beschränkten Sie die Sichtbarkeit eines Artikels auf eine Benutzergruppe, der Sie nicht angehören. </@l10n>
                <#else>
                    <@l10n> Am ${time} beschränkte <span style="${bold}">${from.getVisibleName()}</span> die Sichtbarkeit eines Artikels auf eine Benutzergruppe, der Sie nicht angehören. </@l10n>
                </#if>
            <#elseif change.hasEvent("ARTICLE_DELETED")>
                <#if from==to>
                    <@l10n> Am ${time} löschten Sie einen Artikel im Projekt <span style="${bold}">${projectName}</span>. </@l10n>
                <#else>
                    <@l10n> Am ${time} löschte <span style="${bold}">${from.getVisibleName()}</span> einen Artikel im Projekt <span style="${bold}">${projectName}</span>. </@l10n>
                </#if>
            <#else>
                <@l10n> Am ${time} beschränkte <span style="${bold}">${from.getVisibleName()}</span> den Zugriff auf einen Artikel. </@l10n>
            </#if>
        <#else>
            <#if from == to>
                <@l10n> Am ${time} aktualisierten <span style="${bold}">Sie</span> einen Artikel im Projekt ${projectName}. </@l10n>
            <#else>
                <@l10n> Am ${time} aktualisierte <span style="${bold}">${from.getVisibleName()}</span> einen Artikel im Projekt ${projectName}. </@l10n>
            </#if>
        </#if>
    </div>
</#escape>
