<#ftl attributes={"description":"Overview of the article update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign projectName = article.project.name>
    <#assign time = change.getWhen()>
    <#if change.hasEvent("ARTICLE_CREATED")>
        <@l10n>
            Am ${time} hat ${article.author.getVisibleName()} einen Artikel zum Projekt ${projectName} hinzugefügt.
        </@l10n>
    <#elseif last_notification?has_content && last_notification>
        <#if change.hasEvent("ARTICLE_PROJECT")>
            <#if from == to>
                <@l10n> Am ${time} haben Sie einen Artikel in ein Projekt verschoben, in dem Sie keine Artikel-Leseberechtigung haben. </@l10n>
            <#else>
                <@l10n> Am ${time} hat ${from.getVisibleName()} einen Artikel in ein Projekt verschoben, in dem Sie keine Artikel-Leseberechtigung haben. </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_VISIBILITY")>
            <#if from == to>
                <@l10n> Am ${time} beschränkten Sie die Sichtbarkeit eines Artikels auf eine Benutzergruppe, der Sie nicht angehören. </@l10n>
            <#else>
                <@l10n> Am ${time} beschränkte ${from.getVisibleName()} die Sichtbarkeit eines Artikels auf eine Benutzergruppe, der Sie nicht angehören. </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_DELETED")>
            <#if from == to>
                <@l10n> Am ${time} löschten Sie einen Artikel im Projekt ${projectName}. </@l10n>
            <#else>
                <@l10n> Am ${time} löschte ${from.getVisibleName()} einen Artikel im Projekt ${projectName}. </@l10n>
            </#if>
        <#else>
            <@l10n> Am ${time} beschränkte ${from.getVisibleName()} den Zugriff auf einen Artikel. </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <@l10n> Am ${time} aktualisierten Sie einen Artikel im Projekt ${projectName}. </@l10n>
        <#else>
            <@l10n> Am ${time} aktualisierte ${from.getVisibleName()} einen Artikel im Projekt ${projectName}. </@l10n>
        </#if>
    </#if>
</p>
</#escape>
