<#ftl attributes={"description":"Presentation of an issue with all significant properties: id, description, summary, values of fields etc."}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <tr>
        <td colspan="2" style="${styles.event_title}">
            <#if Utils.hasVisibilityRestrictions(issue)>
                <table style="${styles.table}">
                    <tr>
                        <td style="${styles.event_title}"><@l10n>Sichtbar für Gruppe</@l10n></td>
                        <td style="${styles.event_value}">${Utils.getVisibilityPresentation(issue)}</td>
                    </tr>
                </table>
            </#if>
            <#include "tags_panel.ftl">
            <#include "links_panel.ftl">
            <#include "attachments_panel.ftl">
            <#include "text_fields_panel.ftl">
            <hr style="height: 1px;
                       max-height: 1px;
                       border: 0;
                       background: #d9d9d9;
                       margin: 19px 0 15px;"/>
            <#include "fields_panel.ftl">
            <#include "sprints_panel.ftl">
        </td>
    </tr>
</#escape>
