<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>
    <@l10n>Sie (<b>${to.login}</b>) haben diese Nachricht erhalten, da Sie Folgendes abonniert haben:</@l10n>
    <#assign size = reason.subreasons?size>
    <#assign pre_last_index = size - 2>
    <#list reason.subreasons as subreason>
        <#assign type = subreason.type>
        <#assign delimiter = subreason?has_next?then((subreason?index == pre_last_index && size == 2)?then('', ','), '.')>
        <#if type == "@mention" && issue?has_content>
            <@l10n>
@Erwähnungen in Ticketbeschreibungen und -kommentaren${delimiter}            </@l10n>
        <#elseif type == "@mention" && article?has_content>
            <@l10n>
@Erwähnungen im Artikeltext und in Kommentaren${delimiter} </@l10n>
        <#elseif type == "search">
            <@l10n>
Benachrichtigungsereignisse für die gespeicherte Suche <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>${delimiter}            </@l10n>
        <#elseif type == "tag">
            <@l10n>
Benachrichtigungsereignisse für das Tag <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>${delimiter}            </@l10n>
        <#elseif type == "cluster">
            <@l10n>
Änderungen in einem Duplikat-Cluster${delimiter}            </@l10n>
        </#if>
        <#if (subreason?has_next && subreason?index == pre_last_index)>
            <@l10n>und</@l10n>
        </#if>
    </#list>

    <#if (last_notification?has_content && last_notification) || !issue?has_content>
        <@l10n>
Um weniger Nachrichten dieser Art zu erhalten, <a href="${Utils.getSettingUrl(to)}">ändern Sie Ihre Benachrichtigungseinstellungen</a>. </@l10n>
    <#else>
        <@l10n>
Um das Abonnement zu beenden, können Sie die <a href="${Utils.getSettingUrlWithMute(to,issue)}">Benachrichtigungen für dieses Ticket stummschalten</a> oder <a href="${Utils.getSettingUrl(to)}">Ihre Benachrichtigungseinstellungen bearbeiten</a>.        </@l10n>
    </#if>
</#escape>
