<#escape x as x?html>
<html>
    <#import "styles.ftl" as styles>

    <table style="${styles.table} margin: 16px 0;">
        <tr>
            <td style="width: ${styles.icon_width}px;
                       padding: 0;
                       vertical-align: top;">
                <div style="padding: 2px 0 0 14px;">
                    <#include "icon_warning.ftl">
                </div>
            </td>
            <td style="padding: 0; vertical-align: top;">
                <div style="${styles.overview_text}">
                    <@l10n>Am ${vcsChange.humanReadableDate} hat YouTrack eine Änderung verarbeitet, die durch den VCS-Benutzer <b>${vcsChange.userName}</b> angewendet wurde. Die Commit-Meldung enthält einen Befehl, der auf ein Ticket im Projekt ${issue.project.name} verweist. Leider wurde das referenzierte Ticket wegen des folgenden Problems nicht aktualisiert:</@l10n>
                        <br/>
                    <#assign noUserReason = vcsChange.noUserReason>
                    <#if noUserReason?has_content>
                        ${noUserReason}
                    <#else>
                        <@l10n>YouTrack konnte aus einem unbekannten Grund kein Benutzerkonto finden, das dem Änderungs-Autor entspricht.</@l10n>
                    </#if>
                </div>
            </td>
        </tr>
    </table>

    <#include "issue_header.ftl">

    <div style="margin-top: 16px">
        <table style="${styles.table} background: #f0f0f0;">
            <tr>
                <td style="${styles.event_title};">
                    <#include "icon_cross.ftl">
                </td>
                <td style="padding: 12px 0;">
                    ${vcsChange.text}
                </td>
                <td style="padding: 12px 16px;">
                    <a title="${issue.project.name}"
                       style="color: #1466c6; float: right;"
                       href="${vcsChange.changeUrl}">
                        ${vcsChange.version}
                    </a>
                </td>
            </tr>
        </table>
    </div>
    <div style="margin-left: ${styles.icon_width}px; padding: 4px 0 8px;">
	    <#include "vcs_failure_footer.ftl">
    </div>
</html>
</#escape>