<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>
    <@l10n>You (<b>${to.login}</b>) received this message because you subscribe to</@l10n>
    <#assign size = reason.subreasons?size>
    <#assign pre_last_index = size - 2>
    <#list reason.subreasons as subreason>
        <#assign type = subreason.type>
        <#assign delimiter = subreason?has_next?then((subreason?index == pre_last_index && size == 2)?then('', ','), '.')>
        <#if type == "@mention" && issue?has_content>
            <@l10n>
                @mentions in issue descriptions and comments${delimiter}
            </@l10n>
        <#elseif type == "@mention" && article?has_content>
            <@l10n>
                @mentions in article text and comments${delimiter}
            </@l10n>
        <#elseif type == "search">
            <@l10n>
                notification events for the <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b> saved search${delimiter}
            </@l10n>
        <#elseif type == "tag">
            <@l10n>
                notification events for the <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b> tag${delimiter}
            </@l10n>
        <#elseif type == "cluster">
            <@l10n>
                changes in a duplicate cluster${delimiter}
            </@l10n>
        </#if>
        <#if (subreason?has_next && subreason?index == pre_last_index)>
            <@l10n>and</@l10n>
        </#if>
    </#list>

    <#if (last_notification?has_content && last_notification) || !issue?has_content>
        <@l10n>
            To receive fewer messages like this,
            <a href="${Utils.getSettingUrl(to)}">edit your notification preferences</a>.
        </@l10n>
    <#else>
        <@l10n>
            To unsubscribe, you can
            <a href="${Utils.getSettingUrlWithMute(to,issue)}">mute notifications for this issue</a> or
            <a href="${Utils.getSettingUrl(to)}">edit your notification preferences</a>.
        </@l10n>
    </#if>
</#escape>
