<#ftl attributes={"description":"Brief reason for sending jabber notification to user (plain text)"}>
<#escape x as x?html>
    <p>
        <@l10n>
            You received this message because you subscribe to
        </@l10n>
        <#assign multiple_reasons = (reason.subreasons?size gt 1)>
        <#assign delimiter = multiple_reasons?then('', '.')>
        <#assign subreason = reason.subreasons[0]>
        <#assign type = subreason.type>
        <#if type == "search">
            <@l10n>
                notification events for the "${subreason.name}"<#if only_via_duplicate> (${subreason.issueId})</#if> saved search${delimiter}
            </@l10n>
        <#elseif type == "tag">
            <@l10n>
                notification events for the "${subreason.name}"<#if only_via_duplicate> (${subreason.issueId})</#if> tag${delimiter}
            </@l10n>
        <#elseif type == "cluster">
            <@l10n>
                changes in a duplicate cluster${delimiter}
            </@l10n>
        <#elseif type == "@mention" && issue?has_content>
            <@l10n>
                @mentions in issue descriptions and comments${delimiter}
            </@l10n>
        <#elseif type == "@mention" && article?has_content>
            <@l10n>
                @mentions in article text and comments${delimiter}
            </@l10n>
        </#if>
        <#if multiple_reasons>
            <@l10n>and at least one more event</@l10n>.
        </#if>
    </p>
</#escape>
