<#ftl attributes={"description":"Overview of the article update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text} padding: 12px 16px;">
        <#assign bold = "font-weight: bold;">
        <#assign projectName = article.project.name>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("ARTICLE_CREATED")>
                <@l10n>
                        El ${time}, <span style="${bold}">${from.getVisibleName()}</span> añadió un artículo
                        al proyecto <span style="${bold}">${projectName}</span>.
                </@l10n>
        <#elseif last_notification?has_content && last_notification>
            <#if change.hasEvent("ARTICLE_PROJECT")>
                <#if from==to>
                    <@l10n>
                        El ${time}, movió un artículo
                        a un proyecto en el que usted no tiene permiso para leer artículos.
                    </@l10n>
                <#else>
                    <@l10n>
                        El ${time}, <span style="${bold}">${from.getVisibleName()}</span> movió un artículo
                        a un proyecto en el que usted no tiene permiso para leer artículos.
                    </@l10n>
                </#if>
            <#elseif change.hasEvent("ARTICLE_VISIBILITY")>
                <#if from==to>
                    <@l10n>
                        El ${time}, restringió la visibilidad
                        de un artículo a un grupo de usuarios al que usted no pertenece.
                    </@l10n>
                <#else>
                    <@l10n>
                        El ${time}, <span style="${bold}">${from.getVisibleName()}</span> restringió la visibilidad
                        de un artículo a un grupo de usuarios al que usted no pertenece.
                    </@l10n>
                </#if>
            <#elseif change.hasEvent("ARTICLE_DELETED")>
                <#if from==to>
                    <@l10n>
                        El ${time}, eliminó un artículo
                        en el proyecto <span style="${bold}">${projectName}</span>.
                    </@l10n>
                <#else>
                    <@l10n>
                        El ${time}, <span style="${bold}">${from.getVisibleName()}</span> eliminó un artículo
                        en el proyecto <span style="${bold}">${projectName}</span>.
                    </@l10n>
                </#if>
            <#else>
                <@l10n>
                    El ${time}, <span style="${bold}">${from.getVisibleName()}</span> restringió el acceso a un artículo.
                </@l10n>
            </#if>
        <#else>
            <#if from == to>
                <@l10n>
                    El ${time}, <span style="${bold}">usted</span> actualizó un artículo
                    en el proyecto ${projectName}.
                </@l10n>
            <#else>
                <@l10n>
                    El ${time}, <span style="${bold}">${from.getVisibleName()}</span> actualizó un artículo
                    en el proyecto ${projectName}.
                </@l10n>
            </#if>
        </#if>
    </div>
</#escape>
