<#ftl attributes={"description":"Overview of the article update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign projectName = article.project.name>
    <#assign time = change.getWhen()>
    <#if change.hasEvent("ARTICLE_CREATED")>
        <@l10n>
                    El ${time}, ${article.author.getVisibleName()} añadió un artículo al proyecto ${projectName}.
        </@l10n>
    <#elseif last_notification?has_content && last_notification>
        <#if change.hasEvent("ARTICLE_PROJECT")>
            <#if from == to>
                <@l10n>
                    El ${time}, movió un artículo
                        a un proyecto en el que usted no tiene permiso para leer artículos.
                </@l10n>
            <#else>
                <@l10n>
                        El ${time}, ${from.getVisibleName()} movió un artículo
                        a un proyecto en el que usted no tiene permiso para leer artículos.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_VISIBILITY")>
            <#if from == to>
                <@l10n>
                    El ${time}, usted restringió la visibilidad de un artículo
                    a un grupo de usuarios al que usted no pertenece.
                </@l10n>
            <#else>
                <@l10n>
                    El ${time}, ${from.getVisibleName()} restringió la visibilidad de un artículo
                    a un grupo de usuarios al que usted no pertenece.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_DELETED")>
            <#if from == to>
                <@l10n>
                    El ${time}, usted eliminó un artículo en el proyecto ${projectName}.
                </@l10n>
            <#else>
                <@l10n>
                    El ${time}, ${from.getVisibleName()} eliminó un artículo en el proyecto ${projectName}.
                </@l10n>
            </#if>
        <#else>
            <@l10n>
                    El ${time}, ${from.getVisibleName()} restringió el acceso a un artículo.
            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <@l10n>
                    El ${time}, usted actualizó un artículo en el proyecto ${projectName}.
            </@l10n>
        <#else>
            <@l10n>
                    El ${time}, ${from.getVisibleName()} actualizó un artículo en el proyecto ${projectName}.
            </@l10n>
        </#if>
    </#if>
</p>
</#escape>
