<#ftl attributes={"description":"Overview of the issue update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign priority = issue.Priority>
    <#assign isShowStopper = (!priority?is_enumerable && priority == "Show-stopper")>
    <#if change.hasEvent("CREATED")>
        <#if (!priority?is_enumerable && priority == "Show-stopper")>
            <@l10n>Obstaculizador nuevo notificado por ${issue.reporter.getVisibleName()}:</@l10n>
        <#else>
            <@l10n>Incidencia nueva notificada por ${issue.reporter.getVisibleName()}:</@l10n>
        </#if>
    <#elseif last_notification?has_content && last_notification>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("PROJECT")>
            <#if from == to>
                <@l10n>
                        El ${time}, usted movió una incidencia a un proyecto en el que no tiene permiso para leer incidencias.
                </@l10n>
            <#else>
                <@l10n>
                    El ${time}, ${from.getVisibleName()} movió una incidencia a un proyecto en el que usted no tiene permiso para leer incidencias.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("PERMITTED")>
            <#if from == to>
                <@l10n>
                    El ${time}, usted restringió la visibilidad de una incidencia a un grupo de usuarios al que usted no pertenece.
                </@l10n>
            <#else>
                <@l10n>
                    El ${time}, ${from.getVisibleName()} restringió la visibilidad de una incidencia a un grupo de usuarios al que usted no pertenece.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("DELETED")>
            <#if from == to>
                <@l10n>
                    El ${time}, usted eliminó una incidencia en el proyecto ${issue.project.name}.
                </@l10n>
            <#else>
                <@l10n>
                    El ${time}, ${from.getVisibleName()} eliminó una incidencia en el proyecto ${issue.project.name}.
                </@l10n>
            </#if>
        <#else>
            <@l10n>
                El ${time}, ${from.getVisibleName()} restringió el acceso a una incidencia.
            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <#if isShowStopper>
                <@l10n>Usted ha modificado el obstaculizador:</@l10n>
            <#else>
                <@l10n>Usted ha modificado la incidencia:</@l10n>
            </#if>
        <#else>
            <#if isShowStopper>
                <@l10n>El usuario ${from.getVisibleName()} ha modificado el obstaculizador:</@l10n>
            <#else>
                <@l10n>El usuario ${from.getVisibleName()} ha modificado la incidencia:</@l10n>
            </#if>
        </#if>
    </#if>
</p>
</#escape>