<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>
    <@l10n>Usted (<b>${to.login}</b>) ha recibido este mensaje porque se ha suscrito a</@l10n>
    <#assign size = reason.subreasons?size>
    <#assign pre_last_index = size - 2>
    <#list reason.subreasons as subreason>
        <#assign type = subreason.type>
        <#assign delimiter = subreason?has_next?then((subreason?index == pre_last_index && size == 2)?then('', ','), '.')>
        <#if type == "@mention" && issue?has_content>
            <@l10n>
                @menciones en descripciones y comentarios de incidencias${delimiter}
            </@l10n>
        <#elseif type == "@mention" && article?has_content>
            <@l10n>
                @menciones en texto del artículo y comentarios${delimiter}
            </@l10n>
        <#elseif type == "search">
            <@l10n>
                eventos de notificación para la búsqueda guardada <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>${delimiter}
            </@l10n>
        <#elseif type == "tag">
            <@l10n>
                eventos de notificación para la etiqueta <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>${delimiter}
            </@l10n>
        <#elseif type == "cluster">
            <@l10n>
                cambios en un grupo duplicado${delimiter}
            </@l10n>
        </#if>
        <#if (subreason?has_next && subreason?index == pre_last_index)>
            <@l10n>y</@l10n>
        </#if>
    </#list>

    <#if (last_notification?has_content && last_notification) || !issue?has_content>
        <@l10n>
            Para recibir menos mensajes como este,
            <a href="${Utils.getSettingUrl(to)}">edite sus preferencias de notificaciones.</a>
        </@l10n>
    <#else>
        <@l10n>
            Para cancelar la suscripción puede
            <a href="${Utils.getSettingUrlWithMute(to,issue)}">silenciar las notificaciones de esta incidencia</a> o
            <a href="${Utils.getSettingUrl(to)}">editar sus preferencias de notificaciones</a>.
        </@l10n>
    </#if>
</#escape>
