<#ftl attributes={"description":"Overview of the article update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign projectName = article.project.name>
    <#assign time = change.getWhen()>
    <#if change.hasEvent("ARTICLE_CREATED")>
        <@l10n>
            À ${time}, ${article.author.getVisibleName()} a ajouté un article au projet ${projectName}.
        </@l10n>
    <#elseif last_notification?has_content && last_notification>
        <#if change.hasEvent("ARTICLE_PROJECT")>
            <#if from == to>
                <@l10n>
Le ${time}, vous avez déplacé un article 
vers un projet pour lequel vous n'avez pas l'autorisation de lire des articles.
                </@l10n>
            <#else>
                <@l10n>
Le ${time}, ${from.getVisibleName()} a déplacé un article 
vers un projet pour lequel vous n'avez pas l'autorisation de lire les articles.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_VISIBILITY")>
            <#if from == to>
                <@l10n>
Le ${time}, vous avez restreint la visibilité d'un article 
à un groupe d'utilisateurs auquel vous n'appartenez pas.
                </@l10n>
            <#else>
                <@l10n>
Le ${time}, ${from.getVisibleName()} a restreint la visibilité d'un article 
à un groupe d'utilisateurs auquel vous n'appartenez pas.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_DELETED")>
            <#if from == to>
                <@l10n>
Le ${time}, vous avez supprimé un article dans le projet ${projectName}.
                </@l10n>
            <#else>
                <@l10n>
Le ${time}, ${from.getVisibleName()} a supprimé un article dans le projet ${projectName}.
                </@l10n>
            </#if>
        <#else>
            <@l10n>
Le ${time}, ${from.getVisibleName()} a restreint l'accès à un article.
            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <@l10n>
Le ${time}, vous avez mis à jour un article dans le projet ${projectName}.
            </@l10n>
        <#else>
            <@l10n>
Le ${time}, ${from.getVisibleName()} a mis à jour un article dans le projet ${projectName}.
            </@l10n>
        </#if>
    </#if>
</p>
</#escape>
