<#ftl attributes={"description":"List of added and removed attachments"}>
<#escape x as x?html>
    <#assign attachments = issue.attachments>
    <#if attachments?has_content>
    <ul style="margin: 1em 0 0 0 !important;
               padding: 0 !important">
        <#list attachments as attachment>
            <li style="display: inline-block;
                       font-size: 13px;
                       list-style: none;
                       padding: 0 !important;
                       margin: 0 !important;">
                <#assign attachmentUrl = Utils.getAttachmentUrl(attachment)>
                <a title="<#if Utils.hasVisibilityRestrictions(attachment)>
                                <@l10n>Ajouté par ${attachment.author.getVisibleName()} pour ${Utils.getVisibilityPresentation(attachment)}</@l10n>
                          <#else>
                                <@l10n>Ajouté par ${attachment.author.getVisibleName()}</@l10n>
                          </#if>"
                   <#if attachmentUrl?has_content>
                        href="${attachmentUrl}"
                   </#if>
                >
                    <span style="color: #105CB6;
                                 text-decoration: none;">
                        ${attachment.name}
                    </span>
                </a>
                <span style="color: #9EA1A5; font-size:11px;">
                    <#if attachment.size?has_content>
                        <#assign size = attachment.size>
                        <#if (size < 1024)>
                            (<@l10n>${size}&nbsp;o</@l10n>)
                        <#else>
                            <#if (1024 <= size && size < 1024*1024) >
                                (<@l10n>${size/1024}&nbsp;Ko</@l10n>)
                            <#else>
                                (<@l10n>${size/(1024*1024)}&nbsp;Mo</@l10n>)
                            </#if>
                        </#if>
                    <#else>
                        (<@l10n>0&nbsp;o</@l10n>)
                    </#if>
                </span>
            </li>
        </#list>
    </ul>
    </#if>
    <#assign invisibleCount = Utils.getInvisibleAttachmentsCount(issue)>
    <#if (invisibleCount > 0)>
        <div>
            <#if (invisibleCount == 1)>
                <@l10n>Vous n’avez pas l’autorisation de consulter 1 pièce jointe supplémentaire pour ce ticket</@l10n>
            <#else >
                <@l10n>Vous n’avez pas l’autorisation de consulter ${invisibleCount} pièces jointes supplémentaires pour ce ticket</@l10n>
            </#if>
        </div>
    </#if>
</#escape>
