<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>
    <@l10n>Vous (<b>${to.login}</b>) avez reçu ce message en raison de votre abonnement à</@l10n>
    <#assign size = reason.subreasons?size>
    <#assign pre_last_index = size - 2>
    <#list reason.subreasons as subreason>
        <#assign type = subreason.type>
        <#assign delimiter = subreason?has_next?then((subreason?index == pre_last_index && size == 2)?then('', ','), '.')>
        <#if type == "@mention" && issue?has_content>
            <@l10n>
                @mentions dans les descriptions et les commentaires de ticket${delimiter}
            </@l10n>
        <#elseif type == "@mention" && article?has_content>
            <@l10n>
@mentions dans le texte de l'article et les commentaires ${delimiter}
            </@l10n>
        <#elseif type == "search">
            <@l10n>
                événements de notification pour la recherche enregistrée <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>${delimiter}
            </@l10n>
        <#elseif type == "tag">
            <@l10n>
                événements de notification pour la balise <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>${delimiter}
            </@l10n>
        <#elseif type == "cluster">
            <@l10n>
                modifications dans un cluster en doublon${delimiter}
            </@l10n>
        </#if>
        <#if (subreason?has_next && subreason?index == pre_last_index)>
            <@l10n>et</@l10n>
        </#if>
    </#list>

    <#if (last_notification?has_content && last_notification) || !issue?has_content>
        <@l10n>
Pour recevoir moins de messages comme celui-ci, 
<a href="${Utils.getSettingUrl(to)}">modifiez vos préférences de notification</a>.
        </@l10n>
    <#else>
        <@l10n>
Vous disposez des options de désinscription suivantes :
<a href="${Utils.getSettingUrlWithMute(to,issue)}">rendre les notifications silencieuses pour ce ticket</a> ou
<a href="${Utils.getSettingUrl(to)}">modifier vos préférences de notification</a>.
        </@l10n>
    </#if>
</#escape>
