<#ftl attributes={"description":"Change of issue tags"}>

<#escape x as x?html>
    <#assign addedTags = event.getAddedValues()>
    <#assign removedTags = event.getRemovedValues()>
    <#import "styles.ftl" as styles>
        <tr>
            <td style="${styles.event_title}">
                <@l10n>תגיות</@l10n>
            </td>
            <td style="${styles.event_value}">
                <#list addedTags as tag>
                    <a style="${styles.tag_bar} ${Utils.getTagStyle(tag)}"
                       title="${tag.name}"
                       href ="${Utils.getTaggedIssuesUrl(tag)}">
                        ${Utils.getTrimmedTagName(tag)}
                    </a>&nbsp;
                </#list>
                <#list removedTags as tag>
                    <a style="${styles.tag_bar} ${Utils.getTagStyle(tag)} text-decoration:line-through!important;"
                       title="${tag.name}"
                       href ="${Utils.getTaggedIssuesUrl(tag)}">
                        ${Utils.getTrimmedTagName(tag)}
                    </a>&nbsp;
                </#list>
            </td>
        </tr>
</#escape>