<#ftl attributes={"description":"Overview of the article update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text} padding: 12px 16px;">
        <#assign bold = "font-weight: bold;">
        <#assign projectName = article.project.name>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("ARTICLE_CREATED")>
                <@l10n>
            A(z) ${time} időpontban <span style="${bold}">${from.getVisibleName()}</span> hozzáadott egy cikket
            a(z) <span style="${bold}">${projectName}</span> projekthez.
        </@l10n>
        <#elseif last_notification?has_content && last_notification>
            <#if change.hasEvent("ARTICLE_PROJECT")>
                <#if from==to>
                    <@l10n>
            A(z) ${time} időpontban Ön áthelyezett egy cikket
            egy olyan projektbe, amelyben Önnek nincs engedélye a cikkek olvasására.
          </@l10n>
                <#else>
                    <@l10n>
            A(z) ${time} időpontban <span style="${bold}">${from.getVisibleName()}</span> áthelyezett egy cikket
            egy olyan projektbe, amelyben Önnek nincs engedélye a cikkek olvasására. 
          </@l10n>
                </#if>
            <#elseif change.hasEvent("ARTICLE_VISIBILITY")>
                <#if from==to>
                    <@l10n>
            A(z) ${time} időpontban Ön korlátozta a cikk láthatóságát
            egy olyan felhasználói csoportra, amelynek Ön nem tagja.
          </@l10n>
                <#else>
                    <@l10n>
            A(z) ${time} időpontban <span style="${bold}">${from.getVisibleName()}</span> korlátozta a cikk láthatóságát
            egy olyan felhasználói csoportra, amelynek Ön nem tagja.
          </@l10n>
                </#if>
            <#elseif change.hasEvent("ARTICLE_DELETED")>
                <#if from==to>
                    <@l10n>
            A(z) ${time} időpontban törölt egy cikket
            a(z) <span style="${bold}">${projectName}</span> projektből.
          </@l10n>
                <#else>
                    <@l10n>
            A(z) ${time} időpontban <span style="${bold}">${from.getVisibleName()}</span> törölt egy cikket
            a(z) <span style="${bold}">${projectName}</span> projektből.
          </@l10n>
                </#if>
            <#else>
                <@l10n>
          A(z) ${time} időpontban <span style="${bold}">${from.getVisibleName()}</span> korlátozta egy cikk hozzáférését.
        </@l10n>
            </#if>
        <#else>
            <#if from == to>
                <@l10n>
          A(z) ${time} időpontban, <span style="${bold}">Ön</span> frissített egy cikket
          a(z) ${projectName} projektben.
        </@l10n>
            <#else>
                <@l10n>
          A(z) ${time} időpontban, <span style="${bold}">${from.getVisibleName()}</span> frissített egy cikket
          a(z) ${projectName} projektben.
        </@l10n>
            </#if>
        </#if>
    </div>
</#escape>
