<#ftl attributes={"description":"Overview of the article update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign projectName = article.project.name>
    <#assign time = change.getWhen()>
    <#if change.hasEvent("ARTICLE_CREATED")>
        <@l10n>
        A(z) ${time} időpontban ${article.author.getVisibleName()} hozzáadott egy cikket a(z) ${projectName} projekthez.
    </@l10n>
    <#elseif last_notification?has_content && last_notification>
        <#if change.hasEvent("ARTICLE_PROJECT")>
            <#if from == to>
                <@l10n>
          A(z) ${time} időpontban áthelyezett egy cikket
          egy olyan projektbe, amelyben nincs engedélye a cikkek olvasására.
        </@l10n>
            <#else>
                <@l10n>
          A(z) ${time} időpontban ${from.getVisibleName()} áthelyezett egy cikket
          egy olyan projektbe, amelyben Önnek nincs engedélye a cikkek olvasására. 
        </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_VISIBILITY")>
            <#if from == to>
                <@l10n>
          A(z) ${time} időpontban korlátozta a cikk láthatóságát
          egy olyan felhasználói csoportra, amelyhez nem tartozik.
        </@l10n>
            <#else>
                <@l10n>
          A(z) ${time} időpontban ${from.getVisibleName()} korlátozta a cikk láthatóságát
          egy olyan felhasználói csoportra, amelynek Ön nem a tagja.
        </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_DELETED")>
            <#if from == to>
                <@l10n>
          A(z) ${time} időpontban törölt egy cikket a(z) ${projectName} projektből.
        </@l10n>
            <#else>
                <@l10n>
          A(z) ${time} időpontban ${from.getVisibleName()} törölt egy cikket a(z) ${projectName} projektből.
        </@l10n>
            </#if>
        <#else>
            <@l10n>
        A(z) ${time} időpontban ${from.getVisibleName()} korlátozta egy cikk hozzáférését.
      </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <@l10n>
        A(z) ${time} időpontban frissített egy cikket a(z) ${projectName} projektben.
      </@l10n>
        <#else>
            <@l10n>
        A(z) ${time} időpontban ${from.getVisibleName()} frissített egy cikket a(z) ${projectName} projektben.
      </@l10n>
        </#if>
    </#if>
</p>
</#escape>
