<#ftl attributes={"description":"List of added and removed attachments"}>
<#escape x as x?html>
    <#assign attachments = issue.attachments>
    <#if attachments?has_content>
    <ul style="margin: 1em 0 0 0 !important;
               padding: 0 !important">
        <#list attachments as attachment>
            <li style="display: inline-block;
                       font-size: 13px;
                       list-style: none;
                       padding: 0 !important;
                       margin: 0 !important;">
                <#assign attachmentUrl = Utils.getAttachmentUrl(attachment)>
                <a title="<#if Utils.hasVisibilityRestrictions(attachment)>
                                <@l10n>${attachment.author.getVisibleName()} adta hozzá ${Utils.getVisibilityPresentation(attachment)} céljára</@l10n>
                          <#else>
                                <@l10n>${attachment.author.getVisibleName()} adta hozzá</@l10n>
                          </#if>"
                   <#if attachmentUrl?has_content>
                        href="${attachmentUrl}"
                   </#if>
                >
                    <span style="color: #105CB6;
                                 text-decoration: none;">
                        ${attachment.name}
                    </span>
                </a>
                <span style="color: #9EA1A5; font-size:11px;">
                    <#if attachment.size?has_content>
                        <#assign size = attachment.size>
                        <#if (size < 1024)>
                            (<@l10n>${size}&nbsp;B</@l10n>)
                        <#else>
                            <#if (1024 <= size && size < 1024*1024) >
                                (<@l10n>${size/1024}&nbsp;kB</@l10n>)
                            <#else>
                                (<@l10n>${size/(1024*1024)}&nbsp;MB</@l10n>)
                            </#if>
                        </#if>
                    <#else>
                        (<@l10n>0&nbsp;B</@l10n>)
                    </#if>
                </span>
            </li>
        </#list>
    </ul>
    </#if>
    <#assign invisibleCount = Utils.getInvisibleAttachmentsCount(issue)>
    <#if (invisibleCount > 0)>
        <div>
            <#if (invisibleCount == 1)>
                <@l10n>Nincs engedélye a hibajegy még 1 mellékletének a megtekintésére</@l10n>
            <#else >
                <@l10n>Nincs engedélye a hibajegy további ${invisibleCount} mellékletének megtekintésére</@l10n>
            </#if>
        </div>
    </#if>
</#escape>
