<#ftl attributes={"description":"Overview of the issue update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text}
            margin: 14px 0 19px ${styles.icon_width}px;">
        <#assign bold = "font-weight: bold;">
        <#assign priority = issue.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000;" + bold>
        <#else>
            <#assign issueTypeStyle = bold>
        </#if>
        <#assign type = issue.Type>
        <#assign time = change.getWhen()>
        <#if type?has_content>
            <#assign issueName = type>
        <#else>
            <#assign issueName = "Issue">
        </#if>
        <#if change.hasEvent("CREATED")>
            <#if type?has_content>
                <@l10n>Új <span style="${issueTypeStyle}">${type}</span> típus a <span style="${bold}">${issue.project.name}</span> projektben</@l10n>
            <#else>
                <@l10n>Új <span style="${issueTypeStyle}">hibajegy</span> a <span style="${bold}">${issue.project.name}</span> projektben</@l10n>
            </#if>
        <#elseif last_notification?has_content && last_notification>
            <#if change.hasEvent("PROJECT")>
                <#if from==to>
                    <@l10n>
     A(z) ${time} napon áthelyezett egy hibajegyet egy olyan projektbe, amelyben nincs engedélye a hibajegyek olvasására.
     </@l10n>
                <#else>
                    <@l10n>
      A(z) ${time} napon <span style="${bold}">${from.getVisibleName()}</span> áthelyezett egy hibajegyet
      egy olyan projektbe, amelyben Önnek nincs engedélye a hibajegyek olvasására.     </@l10n>
                </#if>
            <#elseif change.hasEvent("PERMITTED")>
                <#if from==to>
                    <@l10n>
     A(z) ${time} napon korlátozta a hibajegy láthatóságát olyan felhasználói csoportra, amelyhez nem tartozik.
     </@l10n>
                <#else>
                    <@l10n>
      A(z) ${time} napon <span style="${bold}">${from.getVisibleName()}</span> korlátozta a hibajegy láthatóságát
      egy olyan felhasználói csoportra, amelynek Ön nem tagja.
     </@l10n>
                </#if>
            <#elseif change.hasEvent("DELETED")>
                <#if from==to>
                    <@l10n>
      A(z) ${time} napon törölt egy hibajegyet a(z) <span style="${bold}">${issue.project.name}</span> projektből.
     </@l10n>
                <#else>
                    <@l10n>
      A(z) ${time} napon <span style="${bold}">${from.getVisibleName()}</span> törölt egy hibajegyet a(z) <span style="${bold}">${issue.project.name}</span> projektből.
     </@l10n>
                </#if>
            <#else>
                <@l10n>
    A(z) ${time} napon <span style="${bold}">${from.getVisibleName()}</span> korlátozta egy hibajegy hozzáférését.
    </@l10n>
            </#if>
        <#else>
            <#if from==to>
                <#if type?has_content>
                    <@l10n>
      <span style="${issueTypeStyle}">${type}</span> típust <span style="${bold}">Ön</span> frissítette
      a(z) ${issue.project.name} projektben a(z) ${time} napon.
     </@l10n>
                <#else>
                    <@l10n>
      A(z) <span style="${issueTypeStyle}">hibajegyet</span> <span style="${bold}">Ön</span> frissítette
      a(z) ${issue.project.name} projektben a(z) ${time} napon.
     </@l10n>
                </#if>
            <#else>
                <#if type?has_content>
                    <@l10n>
      <span style="${issueTypeStyle}">${type}</span> típust <span style="${bold}">${from.getVisibleName()}</span> frissítette
      a(z) ${issue.project.name} projektben a(z) ${time} napon.
     </@l10n>
                <#else>
                    <@l10n>
      A(z) <span style="${issueTypeStyle}">hibajegyet</span> <span style="${bold}">${from.getVisibleName()}</span> frissítette
      a(z) ${issue.project.name} projektben a(z) ${time} napon.
     </@l10n>
                </#if>
            </#if>
        </#if>
    </div>
</#escape>