<#ftl attributes={"description":"Overview of the issue update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign priority = issue.Priority>
    <#assign isShowStopper = (!priority?is_enumerable && priority == "Show-stopper")>
    <#if change.hasEvent("CREATED")>
        <#if (!priority?is_enumerable && priority == "Show-stopper")>
            <@l10n>${issue.reporter.getVisibleName()} új fatális hibát (show-stopper) jelentett be:</@l10n>
        <#else>
            <@l10n>Új hibajegyet jelentett ${issue.reporter.getVisibleName()}:</@l10n>
        </#if>
    <#elseif last_notification?has_content && last_notification>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("PROJECT")>
            <#if from == to>
                <@l10n>
     A(z) ${time} napon áthelyezett egy hibajegyet egy olyan projektbe, amelyben nincs engedélye a hibajegyek olvasására.
    </@l10n>
            <#else>
                <@l10n>
     A(z) ${time} napon ${from.getVisibleName()} áthelyezett egy hibajegyet egy olyan projektbe, amelyben Önnek nincs engedélye a hibajegyek olvasására.
    </@l10n>
            </#if>
        <#elseif change.hasEvent("PERMITTED")>
            <#if from == to>
                <@l10n>
     A(z) ${time} napon korlátozta a hibajegy láthatóságát olyan felhasználói csoportra, amelyhez nem tartozik.
    </@l10n>
            <#else>
                <@l10n>
     A(z) ${time} napon ${from.getVisibleName()} korlátozta a hibajegy láthatóságát olyan felhasználói csoportra, amelyhez Ön nem tartozik.
    </@l10n>
            </#if>
        <#elseif change.hasEvent("DELETED")>
            <#if from == to>
                <@l10n>
     A(z) ${time} napon törölt egy hibajegyet a(z) ${issue.project.name} projektből.
    </@l10n>
            <#else>
                <@l10n>
     A(z) ${time} napon ${from.getVisibleName()} törölt egy hibajegyet a(z) ${issue.project.name} projektből.
    </@l10n>
            </#if>
        <#else>
            <@l10n>
    A(z) ${time} napon ${from.getVisibleName()} korlátozta egy hibajegy hozzáférését.
   </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <#if isShowStopper>
                <@l10n>Megváltoztatta a fatális hibát (show-stopper):</@l10n>
            <#else>
                <@l10n>Ön megváltoztatta a hibajegyet:</@l10n>
            </#if>
        <#else>
            <#if isShowStopper>
                <@l10n>Felhasználó ${from.getVisibleName()} megváltoztatta a fatális hibát (show-stopper):</@l10n>
            <#else>
                <@l10n>Felhasználó ${from.getVisibleName()} megváltoztatta a hibajegyet:</@l10n>
            </#if>
        </#if>
    </#if>
</p>
</#escape>