<#ftl attributes={"description":"Presentation of a change in comments (new comment or comment text update)"}>
<#escape x as x?html>
    <#assign comment = event.comment>
    <#assign oldCommentText = event.oldValue>
    <#assign newCommentText  = event.newValue>
    <#import "styles.ftl" as styles>
    <tr style="margin-top: 8px">
        <td style="${styles.event_title}
                    background:#f0f0f0;">
            <img src="${Utils.getAvatarUrl(comment.author)}"
                 alt="${comment.author.getVisibleName()}"
                 width="24"
                 height="24"/>
        </td>
        <td style="${styles.event_value}
                   background: #f0f0f0;">
            <#if oldCommentText??>
                <#if newCommentText?has_content>
                    <@wiki markdown=comment.usesMarkdown>
                        <#noescape>${newCommentText}</#noescape>
                    </@wiki>
                </#if>
                <#assign attachments = comment.attachments>
                <#if attachments?has_content>
                    <div style="line-height: 22px;
                                margin-bottom: 8px;">
                        <#list attachments as attachment>
                            <#assign attachmentUrl = Utils.getAttachmentUrl(attachment)>
                            <div>
                                <#if attachmentUrl?has_content>
                                    <a href="${attachmentUrl}"
                                <#if Utils.hasVisibilityRestrictions(attachment)>
                                    title="<@l10n>Láthatja: ${Utils.getVisibilityPresentation(attachment)}</@l10n>"
                                </#if>>${attachment.name}</a>
                                <#else>
                                    ${attachment.name}
                                </#if>
                            </div>
                        </#list>
                    </div>
                </#if>
            <#else>
                <@diff oldText=oldCommentText
                       newText=newCommentText
                       insStyle="${styles.new_value}"
                       delStyle="${styles.old_value}"/>
            </#if>

            <#if Utils.hasVisibilityRestrictions(comment)>
                <div style="color: #8c8c8c;
                            font-size: 85%;
                            margin-top: 5px;">
                    <@l10n>láthatja: ${Utils.getVisibilityPresentation(comment)}</@l10n>
                </div>
            </#if>

            <div style="display: inline-block;
                        font-size: 85%;
                        margin-top: 8px;">
                <a style="color: #105CB6;"
                   href="${comment.url}"><@l10n>Nézet</@l10n></a>
                <#assign replyLink = Utils.getCommentReplyUrl(comment)>
                <#if replyLink?has_content>
                    <a style="color: #105CB6;
                              margin-left: 5px;"
                       href="${replyLink}"><@l10n>Válasz</@l10n></a>
                </#if>
            </div>
        </td>
    </tr>
</#escape>
