<#escape x as x?html>
<html>
    <#import "styles.ftl" as styles>
    <table style="${styles.table} margin: 16px 0;">
        <tr>
            <td style="width: ${styles.icon_width}px;
                       padding: 0;
                       vertical-align: top;">
                <div style="padding: 2px 0 0 14px;">
                        <#include "icon_warning.ftl">
                </div>
            </td>
            <td style="padding: 0; vertical-align: top;">
                <div style="${styles.overview_text}">
                    <@l10n>
A YouTrack ${vcsChange.humanReadableDate} napon feldolgozott egy VCS-módosítást <b>${vcsChange.userName}</b> által. A közzététel üzenet olyan parancsot tartalmaz, amely hivatkozik a(z) ${issue.project.name} projekt egyik hibajegyére. A parancs sajnos nem érvényes. A hivatkozott hibajegy nem frissült.
     </@l10n>
                    <br/>
                    <br/>
                    <#list vcsChange.commandExecutionInfos as error>
                        <#if error.errorText?has_content>
                            <#noescape>${error.errorText}</#noescape><br/>
                        </#if>
                    </#list>
                    <br/>
                    <br/>
                    <@l10n>
      A hibajegy módosításához az üzenetben lévő hivatkozásra kattintva nyissa meg a hibajegyet a YouTrack-ben, és alkalmazza manuálisan a kívánt változtatásokat.
     </@l10n>
                </div>
            </td>
        </tr>
    </table>

    <#include "issue_header.ftl">

    <div style="margin-top: 16px">
        <table style="${styles.table} background: #f0f0f0;">
            <tr>
                <td style="${styles.event_title};">
                    <img src="${Utils.getAvatarUrl(vcsChange.user)}"
                         alt="${vcsChange.user.getVisibleName()}"
                         width="24"
                         height="24"/>
                </td>

                <td style="padding: 12px 0;">
                    ${vcsChange.text}
                </td>
                <td style="padding: 12px 16px;">
                    <a title="${issue.project.name}"
                       style="color: #1466c6; float: right;"
                       href="${vcsChange.changeUrl}">
                        ${vcsChange.version}
                    </a>
                </td>
            </tr>
        </table>
    </div>
    <div style="margin-left: ${styles.icon_width}px; padding: 4px 0 8px;">
        <#include "vcs_failure_footer.ftl">
    </div>
</html>
</#escape>