<#ftl attributes={"description":"Overview of the article update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign projectName = article.project.name>
    <#assign time = change.getWhen()>
    <#if change.hasEvent("ARTICLE_CREATED")>
        <@l10n>
            ${article.author.getVisibleName()}さんが${time}に${projectName}プロジェクトに記事を追加しました。
        </@l10n>
    <#elseif last_notification?has_content && last_notification>
        <#if change.hasEvent("ARTICLE_PROJECT")>
            <#if from == to>
                <@l10n>
                    あなたは${time}に記事を読み込む権限のないプロジェクトに記事を移動しました。
                    
                </@l10n>
            <#else>
                <@l10n>
                    ${from.getVisibleName()}さんが${time}にあなたが記事を読み込む権限のないプロジェクトに記事を移動しました。
                    
                </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_VISIBILITY")>
            <#if from == to>
                <@l10n>
                    あなたは${time}に自分が所属していないユーザーグループに対して記事の表示を制限しました。
                    
                </@l10n>
            <#else>
                <@l10n>
                    ${from.getVisibleName()}さんが${time}にあなたが所属していないユーザーグループに対して記事の表示を制限しました。
                    
                </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_DELETED")>
            <#if from == to>
                <@l10n>
                    あなたは${time}に${projectName}プロジェクトの記事を削除しました。
                </@l10n>
            <#else>
                <@l10n>
                    ${from.getVisibleName()}さんが${time}に${projectName}プロジェクトの記事を削除しました。
                </@l10n>
            </#if>
        <#else>
            <@l10n>
                ${from.getVisibleName()}さんが${time}に記事へのアクセスを制限しました。
            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <@l10n>
                あなたは${time}に${projectName}プロジェクトの記事を更新しました。
            </@l10n>
        <#else>
            <@l10n>
                    ${from.getVisibleName()}さんが${time}に${projectName}プロジェクトの記事を更新しました。
            </@l10n>
        </#if>
    </#if>
</p>
</#escape>
