<#ftl attributes={"description":"Change of issue attachments"}>
<#escape x as x?html>
    <#assign addedAttachments = event.getAddedValues()>
    <#assign removedAttachments = event.getRemovedValues()>
    <#import "styles.ftl" as styles>
    <tr>
        <#list removedAttachments as removedAttachment>
            <td style="${styles.event_title}">
                <@l10n>アタッチメント</@l10n>
            </td>
            <td style="${styles.event_value}">
                <#assign removedAttachmentUrl = Utils.getAttachmentUrl(removedAttachment)>
                <a style="${styles.old_value}"
                <#if removedAttachmentUrl?has_content>
                   href="${removedAttachmentUrl}"
                </#if>
                <#if Utils.hasVisibilityRestrictions(removedAttachment)>
                   title="<@l10n>${removedAttachment.author.fullName}さんが削除、${Utils.getVisibilityPresentation(removedAttachment)}に表示されます</@l10n>"
                <#else>
                   title="<@l10n>${removedAttachment.author.fullName}さんが削除</@l10n>"
                </#if>>
                    ${removedAttachment.name}
                </a>
            </td>

        </#list>
        <#list addedAttachments as addedAttachment>
            <td style="${styles.event_title}">
                <@l10n>Attachment</@l10n>
            </td>
            <td style="${styles.event_value}">
                <#assign addedAttachmentUrl = Utils.getAttachmentUrl(addedAttachment)>
                <a style="${styles.new_value}"
                <#if addedAttachmentUrl?has_content>
                    href="${addedAttachmentUrl}"
                </#if>
                <#if Utils.hasVisibilityRestrictions(addedAttachment)>
                   title="<@l10n>${addedAttachment.author.fullName}さんが追加、${Utils.getVisibilityPresentation(addedAttachment)}に表示されます</@l10n>"
                <#else>
                   title="<@l10n>${addedAttachment.author.fullName}さんが追加</@l10n>"
                </#if>>
                    ${addedAttachment.name}
                </a>
            </td>
        </#list>
    </tr>
</#escape>
