<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>
    <@l10n>あなた（<b>${to.login}</b>）は次を購読しているため、このメッセージを受信しました：</@l10n>
    <#assign size = reason.subreasons?size>
    <#assign pre_last_index = size - 2>
    <#list reason.subreasons as subreason>
        <#assign type = subreason.type>
        <#assign delimiter = subreason?has_next?then((subreason?index == pre_last_index && size == 2)?then('', ','), '.')>
        <#if type == "@mention" && issue?has_content>
            <@l10n>
                課題の説明とコメントで@メンションされたとき${delimiter}
            </@l10n>
        <#elseif type == "@mention" && article?has_content>
            <@l10n>
                記事の本文とコメントで@メンションされたとき${delimiter}
            </@l10n>
        <#elseif type == "search">
            <@l10n>
                <b>${subreason.name}<#if only_via_duplicate>（${subreason.issueId}）</#if></b>保存した検索条件用の通知イベント${delimiter}
            </@l10n>
        <#elseif type == "tag">
            <@l10n>
                <b>${subreason.name}<#if only_via_duplicate>（${subreason.issueId}）</#if></b>タグ用の通知イベント${delimiter}
            </@l10n>
        <#elseif type == "cluster">
            <@l10n>
重複クラスタ内の変更${delimiter}            </@l10n>
        </#if>
        <#if (subreason?has_next && subreason?index == pre_last_index)>
            <@l10n>および</@l10n>
        </#if>
    </#list>

    <#if (last_notification?has_content && last_notification) || !issue?has_content>
        <@l10n>
            このようなメッセージの受信する頻度を減らすには、
            <a href="${Utils.getSettingUrl(to)}">通知設定を編集</a>してください。
        </@l10n>
    <#else>
        <@l10n>
購読を解除するには、<a href="${Utils.getSettingUrlWithMute(to,issue)}">この課題の通知をミュートする</a>か<a href="${Utils.getSettingUrl(to)}">通知設定を編集してください。</a>
        </@l10n>
    </#if>
</#escape>
