<#ftl attributes={"description":"Overview of the issue update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text}
            margin: 14px 0 19px ${styles.icon_width}px;">
        <#assign bold = "font-weight: bold;">
        <#assign priority = issue.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000;" + bold>
        <#else>
            <#assign issueTypeStyle = bold>
        </#if>
        <#assign type = issue.Type>
        <#assign time = change.getWhen()>
        <#if type?has_content>
            <#assign issueName = type>
        <#else>
            <#assign issueName = "Issue">
        </#if>
        <#if change.hasEvent("CREATED")>
            <#if type?has_content>
                <@l10n><span style="${bold}">${issue.project.name}</span> 프로젝트의 새 <span style="${issueTypeStyle}">${type}</span></@l10n>
            <#else>
                <@l10n><span style="${bold}">${issue.project.name}</span> 프로젝트의 새 <span style="${issueTypeStyle}">이슈</span></@l10n>
            </#if>
        <#elseif last_notification?has_content && last_notification>
            <#if change.hasEvent("PROJECT")>
                <#if from==to>
                    <@l10n>
${time}에 이 계정에서 이슈 읽기 권한이 없는 프로젝트로 이슈를 이동했습니다.                    </@l10n>
                <#else>
                    <@l10n>
${time}에 <span style="${bold}">${from.getVisibleName()}</span>이(가) 이슈 읽기 권한이 없는 프로젝트로 이슈를 이동했습니다.                    </@l10n>
                </#if>
            <#elseif change.hasEvent("PERMITTED")>
                <#if from==to>
                    <@l10n>
${time}에 이 계정에서 이슈 표시를 본인이 속하지 않은 사용자 그룹으로 제한했습니다.                    </@l10n>
                <#else>
                    <@l10n>
${time}에 <span style="${bold}">${from.getVisibleName()}</span>이(가) 이슈 표시를 본인이 속하지 않은 사용자 그룹으로 제한했습니다.                    </@l10n>
                </#if>
            <#elseif change.hasEvent("DELETED")>
                <#if from==to>
                    <@l10n>
${time}에 이 계정에서 <span style="${bold}">${issue.project.name}</span> 프로젝트의 이슈를 삭제했습니다.                    </@l10n>
                <#else>
                    <@l10n>
${time}에 <span style="${bold}">${from.getVisibleName()}</span>이(가) <span style="${bold}">${issue.project.name}</span> 프로젝트의 이슈를 삭제했습니다.                    </@l10n>
                </#if>
            <#else>
                <@l10n>
${time}에 <span style="${bold}">${from.getVisibleName()}</span>이(가) 이슈에 대한 액세스를 제한했습니다.                </@l10n>
            </#if>
        <#else>
            <#if from==to>
                <#if type?has_content>
                    <@l10n>
${time}에 <span style="${bold}">이 계정</span>에서 ${issue.project.name} 프로젝트의 <span style="${issueTypeStyle}">${type}</span>을(를) 업데이트했습니다.                    </@l10n>
                <#else>
                    <@l10n>
${time}에 <span style="${bold}">이 계정</span>에서 ${issue.project.name} 프로젝트의 <span style="${issueTypeStyle}">이슈</span>를 업데이트했습니다.                    </@l10n>
                </#if>
            <#else>
                <#if type?has_content>
                    <@l10n>
${time}에 <span style="${bold}">${from.getVisibleName()}</span>이(가) ${issue.project.name} 프로젝트의 <span style="${issueTypeStyle}">${type}</span>을(를) 업데이트했습니다.                    </@l10n>
                <#else>
                    <@l10n>
${time}에 <span style="${bold}">${from.getVisibleName()}</span>이(가) ${issue.project.name} 프로젝트의 <span style="${issueTypeStyle}">이슈</span>를 업데이트했습니다.                    </@l10n>
                </#if>
            </#if>
        </#if>
    </div>
</#escape>