<#ftl attributes={"description":"Overview of the issue update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign priority = issue.Priority>
    <#assign isShowStopper = (!priority?is_enumerable && priority == "Show-stopper")>
    <#if change.hasEvent("CREATED")>
        <#if (!priority?is_enumerable && priority == "Show-stopper")>
            <@l10n>${issue.reporter.getVisibleName()}이(가) 새 치명적인 버그를 보고했습니다.</@l10n>
        <#else>
            <@l10n>${issue.reporter.getVisibleName()}이(가) 새 이슈를 보고했습니다.</@l10n>
        </#if>
    <#elseif last_notification?has_content && last_notification>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("PROJECT")>
            <#if from == to>
                <@l10n>
${time}에 이 계정에서 이슈 읽기 권한이 없는 프로젝트로 이슈를 이동했습니다.                </@l10n>
            <#else>
                <@l10n>
${time}에 ${from.getVisibleName()}이(가) 이슈 읽기 권한이 없는 프로젝트로 이슈를 이동했습니다.                </@l10n>
            </#if>
        <#elseif change.hasEvent("PERMITTED")>
            <#if from == to>
                <@l10n>
${time}에 이 계정에서 이슈 표시를 본인이 속하지 않은 사용자 그룹으로 제한했습니다.                </@l10n>
            <#else>
                <@l10n>
${time}에 ${from.getVisibleName()}이(가) 이슈 표시를 본인이 속하지 않은 사용자 그룹으로 제한했습니다.                </@l10n>
            </#if>
        <#elseif change.hasEvent("DELETED")>
            <#if from == to>
                <@l10n>
${time}에 이 계정에서 ${issue.project.name} 프로젝트의 이슈를 삭제했습니다.                </@l10n>
            <#else>
                <@l10n>
${time}에 ${from.getVisibleName()}이(가) ${issue.project.name} 프로젝트의 이슈를 삭제했습니다.                </@l10n>
            </#if>
        <#else>
            <@l10n>
${time}에 ${from.getVisibleName()}이(가) 이슈에 대한 액세스를 제한했습니다.            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <#if isShowStopper>
                <@l10n>이 계정에서 치명적인 버그를 변경했습니다.</@l10n>
            <#else>
                <@l10n>이 계정에서 이슈를 변경했습니다.</@l10n>
            </#if>
        <#else>
            <#if isShowStopper>
                <@l10n>사용자 ${from.getVisibleName()}이(가) 치명적인 버그를 변경했습니다.</@l10n>
            <#else>
                <@l10n>사용자 ${from.getVisibleName()}이(가) 이슈를 변경했습니다.</@l10n>
            </#if>
        </#if>
    </#if>
</p>
</#escape>