<#ftl attributes={"description":"Overview of the article update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign projectName = article.project.name>
    <#assign time = change.getWhen()>
    <#if change.hasEvent("ARTICLE_CREATED")>
        <@l10n>
            On ${time}, ${article.author.getVisibleName()} added an article to the ${projectName} project.
        </@l10n>
    <#elseif last_notification?has_content && last_notification>
        <#if change.hasEvent("ARTICLE_PROJECT")>
            <#if from == to>
                <@l10n>
                    On ${time}, you moved an article
                    to a project in which you don't have permission to read articles.
                </@l10n>
            <#else>
                <@l10n>
                    On ${time}, ${from.getVisibleName()} moved an article
                    to a project in which you don't have permission to read articles.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_VISIBILITY")>
            <#if from == to>
                <@l10n>
                    On ${time}, you restricted the visibility of an article
                    to a group of users that you don't belong to.
                </@l10n>
            <#else>
                <@l10n>
                    On ${time}, ${from.getVisibleName()} restricted the visibility of an article
                    to a group of users that you don't belong to.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_DELETED")>
            <#if from == to>
                <@l10n>
                    On ${time}, you deleted an article in the ${projectName} project.
                </@l10n>
            <#else>
                <@l10n>
                    On ${time}, ${from.getVisibleName()} deleted an article in the ${projectName} project.
                </@l10n>
            </#if>
        <#else>
            <@l10n>
                On ${time}, ${from.getVisibleName()} restricted access to an article.
            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <@l10n>
                On ${time}, you updated an article in the ${projectName} project.
            </@l10n>
        <#else>
            <@l10n>
                On ${time}, ${from.getVisibleName()} updated an article in the ${projectName} project.
            </@l10n>
        </#if>
    </#if>
</p>
</#escape>
