<#ftl attributes={"description":"Presentation of custom field values"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <table>
    <#list issue.fields as field>
        <#if !field.usingMarkup>
            <tr>
                <td style="width: ${styles.title_width}px;
                           vertical-align: top;
                           padding: 5px 10px 5px 0;
                           ${styles.content_font}
                           color: #000000;">
                    ${field.name}
                </td>
                <td style="vertical-align: top;
                           padding: 5px;
                           ${styles.content_font}">
                    <#assign background = field.backgroundColor>
                    <#assign foreground = field.foregroundColor>
                    <div style="padding: 2px 4px;
                                font-size: 90%;
                        <#if background?has_content>
                                background-color: ${background} !important;
                        </#if>">
                        <div style="word-wrap: break-word;
                                    overflow: hidden;
                            <#if foreground?has_content>
                                    color: ${foreground} !important;
                            </#if>">
                            ${field.value}
                        </div>
                    </div>
                </td>
            </tr>
        </#if>
    </#list>
    </table>
</#escape>
