<#ftl attributes={"description":"Overview of the article update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text} padding: 12px 16px;">
        <#assign bold = "font-weight: bold;">
        <#assign projectName = article.project.name>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("ARTICLE_CREATED")>
                <@l10n>
                    On ${time}, <span style="${bold}">${from.getVisibleName()}</span> added an article
                    to the <span style="${bold}">${projectName}</span> project.
                </@l10n>
        <#elseif last_notification?has_content && last_notification>
            <#if change.hasEvent("ARTICLE_PROJECT")>
                <#if from==to>
                    <@l10n>
                        On ${time}, you moved an article
                        to a project in which you don't have permission to read articles.
                    </@l10n>
                <#else>
                    <@l10n>
                        On ${time}, <span style="${bold}">${from.getVisibleName()}</span> moved an article
                        to a project in which you don't have permission to read articles.
                    </@l10n>
                </#if>
            <#elseif change.hasEvent("ARTICLE_VISIBILITY")>
                <#if from==to>
                    <@l10n>
                        On ${time}, you restricted the visibility
                        of an article to a group of users that you don't belong to.
                    </@l10n>
                <#else>
                    <@l10n>
                        On ${time}, <span style="${bold}">${from.getVisibleName()}</span> restricted the visibility
                        of an article to a group of users that you don't belong to.
                    </@l10n>
                </#if>
            <#elseif change.hasEvent("ARTICLE_DELETED")>
                <#if from==to>
                    <@l10n>
                        On ${time}, you deleted an article
                        in the <span style="${bold}">${projectName}</span> project.
                    </@l10n>
                <#else>
                    <@l10n>
                        On ${time}, <span style="${bold}">${from.getVisibleName()}</span> deleted an article
                        in the <span style="${bold}">${projectName}</span> project.
                    </@l10n>
                </#if>
            <#else>
                <@l10n>
                    On ${time}, <span style="${bold}">${from.getVisibleName()}</span> restricted access to an article.
                </@l10n>
            </#if>
        <#else>
            <#if from == to>
                <@l10n>
                    On ${time}, <span style="${bold}">you</span> updated an article
                    in the ${projectName} project.
                </@l10n>
            <#else>
                <@l10n>
                    On ${time}, <span style="${bold}">${from.getVisibleName()}</span> updated an article
                    in the ${projectName} project.
                </@l10n>
            </#if>
        </#if>
    </div>
</#escape>
