<#ftl attributes={"description":"Overview of the issue update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text}
            margin: 14px 0 19px ${styles.icon_width}px;">
        <#assign bold = "font-weight: bold;">
        <#assign priority = issue.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000;" + bold>
        <#else>
            <#assign issueTypeStyle = bold>
        </#if>
        <#assign type = issue.Type>
        <#assign time = change.getWhen()>
        <#if type?has_content>
            <#assign issueName = type>
        <#else>
            <#assign issueName = "Issue">
        </#if>
        <#if change.hasEvent("CREATED")>
            <#if type?has_content>
                <@l10n>Nova <span style="${issueTypeStyle}">${type}</span> no projeto <span style="${bold}">${issue.project.name}</span></@l10n>
            <#else>
                <@l10n>Nova <span style="${issueTypeStyle}">issue</span> no projeto <span style="${bold}">${issue.project.name}</span></@l10n>
            </#if>
        <#elseif last_notification?has_content && last_notification>
            <#if change.hasEvent("PROJECT")>
                <#if from==to>
                    <@l10n>
                        Em ${time}, você moveu uma issue para um projeto no qual não tem permissão para ler issues.
                    </@l10n>
                <#else>
                    <@l10n>
Em ${time}, <span style="${bold}">${from.getVisibleName()}</span> moveu uma issue
                         para um projeto no qual você não tem permissão para ler issues.
                    </@l10n>
                </#if>
            <#elseif change.hasEvent("PERMITTED")>
                <#if from==to>
                    <@l10n>
                        Em ${time}, você limitou a visibilidade de uma issue a um grupo de usuários ao qual você não pertence.
                    </@l10n>
                <#else>
                    <@l10n>
                        Em ${time}, <span style="${bold}">$ {from.getVisibleName()}</span> limitou a visibilidade
                        de uma issue a um grupo de usuários ao qual você não pertence.
                    </@l10n>
                </#if>
            <#elseif change.hasEvent("DELETED")>
                <#if from==to>
                    <@l10n>
                        Em ${time}, você excluiu uma issue no projeto <span style="${bold}">${issue.project.name}</span>.
                    </@l10n>
                <#else>
                    <@l10n>
                        Em ${time}, <span style="${bold}">${from.getVisibleName()}</span> excluiu uma issue no <span style="${bold}">${issue.project.name}</span> projeto.
                    </@l10n>
                </#if>
            <#else>
                <@l10n>
                    Em ${time}, <span style="${bold}">${from.getVisibleName()}</span> limitou o acesso a uma issue.
                </@l10n>
            </#if>
        <#else>
            <#if from==to>
                <#if type?has_content>
                    <@l10n>
                        <span style="${issueTypeStyle}">${type}</span> foi atualizada por <span style="${bold}">você</span>
                        no projecto ${issue.project.name} em ${time}.
                    </@l10n>
                <#else>
                    <@l10n>
                        <span style="${issueTypeStyle}">Issue</span> foi atualizada por <span style="${bold}">você</span>
                        no projecto ${issue.project.name} em ${time}.
                    </@l10n>
                </#if>
            <#else>
                <#if type?has_content>
                    <@l10n>
                        <span style="${issueTypeStyle}">${type}</span> foi atualizada por <span style="${bold}">${from.getVisibleName()}</span>
                        no projecto ${issue.project.name} em ${time}.
                    </@l10n>
                <#else>
                    <@l10n>
                        <span style="${issueTypeStyle}">Issue</span> foi atualizada por <span style="${bold}">${from.getVisibleName()}</span>
                        no projecto ${issue.project.name} em ${time}.
                    </@l10n>
                </#if>
            </#if>
        </#if>
    </div>
</#escape>