<#ftl attributes={"description":"Overview of the issue update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign priority = issue.Priority>
    <#assign isShowStopper = (!priority?is_enumerable && priority == "Show-stopper")>
    <#if change.hasEvent("CREATED")>
        <#if (!priority?is_enumerable && priority == "Show-stopper")>
            <@l10n>Nova issue show-stopper foi reportada por ${issue.reporter.getVisibleName()}:</@l10n>
        <#else>
            <@l10n>Nova issue foi reportada por ${issue.reporter.getVisibleName()}:</@l10n>
        </#if>
    <#elseif last_notification?has_content && last_notification>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("PROJECT")>
            <#if from == to>
                <@l10n>
                        Em ${time}, você moveu uma issue para um projeto no qual não tem permissão para ler issues.
                </@l10n>
            <#else>
                <@l10n>
                    Em ${time}, ${from.getVisibleName()} moveu uma issue para um projeto no qual você não tem permissão para ler issues.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("PERMITTED")>
            <#if from == to>
                <@l10n>
                        Em ${time}, você limitou a visibilidade de uma issue a um grupo de usuários ao qual você não pertence.
                </@l10n>
            <#else>
                <@l10n>
                    Em ${time}, $ {from.getVisibleName()} limitou a visibilidade de uma issue a um grupo de usuários ao qual você não pertence.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("DELETED")>
            <#if from == to>
                <@l10n>
                        Em ${time}, você excluiu uma issue no projeto ${issue.project.name}.
                </@l10n>
            <#else>
                <@l10n>
                        Em ${time}, ${from.getVisibleName()} excluiu uma issue no projeto ${issue.project.name}.
                </@l10n>
            </#if>
        <#else>
            <@l10n>
                    Em ${time}, ${from.getVisibleName()} limitou o acesso a uma issue.
            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <#if isShowStopper>
                <@l10n>Você mudou uma issue show-stopper:</@l10n>
            <#else>
                <@l10n>Você mudou a issue:</@l10n>
            </#if>
        <#else>
            <#if isShowStopper>
                <@l10n>Usuário $ {from.getVisibleName ()} mudou uma issue show-stopper:</@l10n>
            <#else>
                <@l10n>Usuário $ {from.getVisibleName ()} mudou a issue:</@l10n>
            </#if>
        </#if>
    </#if>
</p>
</#escape>