<#ftl attributes={"description":"Overview of the article update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text} padding: 12px 16px;">
        <#assign bold = "font-weight: bold;">
        <#assign projectName = article.project.name>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("ARTICLE_CREATED")>
                <@l10n>
${time} пользователь <span style="${bold}">${from.getVisibleName()}</span> добавил статью в проект <span style="${bold}">${projectName}</span>.                </@l10n>
        <#elseif last_notification?has_content && last_notification>
            <#if change.hasEvent("ARTICLE_PROJECT")>
                <#if from==to>
                    <@l10n>
${time} вы переместили статью в проект, в котором у вас нет разрешений на чтение статей.</@l10n>
                <#else>
                    <@l10n>
${time} пользователь <span style="${bold}">${from.getVisibleName()}</span> переместил статью в проект, в котором у вас нет доступа к чтению статей.</@l10n>
                </#if>
            <#elseif change.hasEvent("ARTICLE_VISIBILITY")>
                <#if from==to>
                    <@l10n>
                        ${time} вы сделали статью видимой только для группы пользователей, к которой не принадлежите.
                    </@l10n>
                <#else>
                    <@l10n>
${time} пользователь <span style="${bold}">${from.getVisibleName()}</span> сделал статью видимой только для группы пользователей, к которой вы не принадлежите.
                    </@l10n>
                </#if>
            <#elseif change.hasEvent("ARTICLE_DELETED")>
                <#if from==to>
                    <@l10n>
${time} вы удалили статью из проекта <span style="${bold}">${projectName}</span></@l10n>
                <#else>
                    <@l10n>
${time} пользователь <span style="${bold}">${from.getVisibleName()}</span> удалил статью из проекта <span style="${bold}">${projectName}</span>.</@l10n>
                </#if>
            <#else>
                <@l10n>
${time} пользователь <span style="${bold}">${from.getVisibleName()}</span> ограничил доступ к статье.
                </@l10n>
            </#if>
        <#else>
            <#if from == to>
                <@l10n>
${time} <span style="${bold}">вы</span> обновили статью в проекте ${projectName}.                </@l10n>
            <#else>
                <@l10n>
${time} пользователь <span style="${bold}">${from.getVisibleName()}</span> обновил статью в проекте ${projectName}.                </@l10n>
            </#if>
        </#if>
    </div>
</#escape>
