<#ftl attributes={"description":"Overview of the article update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign projectName = article.project.name>
    <#assign time = change.getWhen()>
    <#if change.hasEvent("ARTICLE_CREATED")>
        <@l10n>
${time} пользователь ${article.author.getVisibleName()} добавил статью в проект ${projectName}.        </@l10n>
    <#elseif last_notification?has_content && last_notification>
        <#if change.hasEvent("ARTICLE_PROJECT")>
            <#if from == to>
                <@l10n>
${time} вы переместили статью в проект, в котором у вас нет разрешения на чтение статей.</@l10n>
            <#else>
                <@l10n>
${time} пользователь ${from.getVisibleName()} переместил статью в проект, в котором у вас нет разрешений на чтение статей.</@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_VISIBILITY")>
            <#if from == to>
                <@l10n>
${time} вы сделали статью видимой только для группы пользователей, к которой не принадлежите.</@l10n>
            <#else>
                <@l10n>
${time} пользователь ${from.getVisibleName()} сделал статью видимой только для группы пользователей, к которой вы не принадлежите.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("ARTICLE_DELETED")>
            <#if from == to>
                <@l10n>
${time} вы удалили статью из проекта ${projectName}.</@l10n>
            <#else>
                <@l10n>
${time} пользователь ${from.getVisibleName()} удалил статью из проекта ${projectName}.</@l10n>
            </#if>
        <#else>
            <@l10n>
${time} пользователь ${from.getVisibleName()} ограничил доступ к статье.</@l10n>
        </#if>
    <#else>
        <#if from == to>
            <@l10n>
${time} вы обновили статью в проекте ${projectName}.</@l10n>
        <#else>
            <@l10n>
${time} пользователь ${from.getVisibleName()} обновил статью в проекте ${projectName}.</@l10n>
        </#if>
    </#if>
</p>
</#escape>
