<#ftl attributes={"description":"Change of issue attachments"}>
<#escape x as x?html>
    <#assign addedAttachments = event.getAddedValues()>
    <#assign removedAttachments = event.getRemovedValues()>
    <#import "styles.ftl" as styles>
    <tr>
        <#list removedAttachments as removedAttachment>
            <td style="${styles.event_title}">
                <@l10n>Прикрепленный файл</@l10n>
            </td>
            <td style="${styles.event_value}">
                <#assign removedAttachmentUrl = Utils.getAttachmentUrl(removedAttachment)>
                <a style="${styles.old_value}"
                <#if removedAttachmentUrl?has_content>
                   href="${removedAttachmentUrl}"
                </#if>
                <#if Utils.hasVisibilityRestrictions(removedAttachment)>
                   title="<@l10n>Удалено пользователем ${removedAttachment.author.fullName}, отображается для ${Utils.getVisibilityPresentation(removedAttachment)}</@l10n>"
                <#else>
                   title="<@l10n>Удалено пользователем ${removedAttachment.author.fullName}</@l10n>"
                </#if>>
                    ${removedAttachment.name}
                </a>
            </td>

        </#list>
        <#list addedAttachments as addedAttachment>
            <td style="${styles.event_title}">
                <@l10n>Attachment</@l10n>
            </td>
            <td style="${styles.event_value}">
                <#assign addedAttachmentUrl = Utils.getAttachmentUrl(addedAttachment)>
                <a style="${styles.new_value}"
                <#if addedAttachmentUrl?has_content>
                    href="${addedAttachmentUrl}"
                </#if>
                <#if Utils.hasVisibilityRestrictions(addedAttachment)>
                   title="<@l10n>Добавлено пользователем ${addedAttachment.author.fullName}, отображается для ${Utils.getVisibilityPresentation(addedAttachment)}</@l10n>"
                <#else>
                   title="<@l10n>Добавлено пользователем ${addedAttachment.author.fullName}</@l10n>"
                </#if>>
                    ${addedAttachment.name}
                </a>
            </td>
        </#list>
    </tr>
</#escape>
