<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>
    <@l10n>Вы (<b>${to.login}</b>) получили это сообщение, поскольку подписаны на</@l10n>
    <#assign size = reason.subreasons?size>
    <#assign pre_last_index = size - 2>
    <#list reason.subreasons as subreason>
        <#assign type = subreason.type>
        <#assign delimiter = subreason?has_next?then((subreason?index == pre_last_index && size == 2)?then('', ','), '.')>
        <#if type == "@mention" && issue?has_content>
            <@l10n>                @упоминания в описаниях задач и комментариях${delimiter}
            </@l10n>
        <#elseif type == "@mention" && article?has_content>
            <@l10n>
@упоминания в тексте статей и комментариях${delimiter}</@l10n>
        <#elseif type == "search">
            <@l10n>
                уведомления о сохраненном поиске <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>${delimiter}
            </@l10n>
        <#elseif type == "tag">
            <@l10n>
                уведомления о теге <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b> tag${delimiter}
            </@l10n>
        <#elseif type == "cluster">
            <@l10n>                изменения в кластере дубликатов${delimiter}
            </@l10n>
        </#if>
        <#if (subreason?has_next && subreason?index == pre_last_index)>
            <@l10n>и</@l10n>
        </#if>
    </#list>

    <#if (last_notification?has_content && last_notification) || !issue?has_content>
        <@l10n>
Чтобы получать меньше подобных сообщений, <a href="${Utils.getSettingUrl(to)}">измените настройку уведомлений</a>.</@l10n>
    <#else>
        <@l10n>
Чтобы отменить подписку, вы можете
    <a href="${Utils.getSettingUrlWithMute(to,issue)}">игнорировать уведомления по этой задаче</a> или
    <a href="${Utils.getSettingUrl(to)}">изменить настройку уведомлений</a>.        </@l10n>
    </#if>
</#escape>
