<#ftl attributes={"description":"Overview of the issue update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text}
            margin: 14px 0 19px ${styles.icon_width}px;">
        <#assign bold = "font-weight: bold;">
        <#assign priority = issue.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000;" + bold>
        <#else>
            <#assign issueTypeStyle = bold>
        </#if>
        <#assign type = issue.Type>
        <#assign time = change.getWhen()>
        <#if type?has_content>
            <#assign issueName = type>
        <#else>
            <#assign issueName = "Issue">
        </#if>
        <#if change.hasEvent("CREATED")>
            <#if type?has_content>
                <@l10n><span style="${bold}">${issue.project.name}</span> 项目中有新<span style="${issueTypeStyle}">${type}</span></@l10n>
            <#else>
                <@l10n><span style="${bold}">${issue.project.name}</span> 项目中有新<span style="${issueTypeStyle}">问题</span></@l10n>
            </#if>
        <#elseif last_notification?has_content && last_notification>
            <#if change.hasEvent("PROJECT")>
                <#if from==to>
                    <@l10n>
                        ${time}，您将一个问题移动到您无权读取问题的项目中。
                    </@l10n>
                <#else>
                    <@l10n>
                        ${time}，<span style="${bold}">${from.getVisibleName()}</span> 将一个问题移动到
                        您无权读取问题的项目中。
                    </@l10n>
                </#if>
            <#elseif change.hasEvent("PERMITTED")>
                <#if from==to>
                    <@l10n>
                        ${time}，您将一个问题的可见范围限制为您不属于的一组用户。
                    </@l10n>
                <#else>
                    <@l10n>
                        ${time}，<span style="${bold}">${from.getVisibleName()}</span> 将一个问题的可见范围限制为
                        您不属于的一组用户。
                    </@l10n>
                </#if>
            <#elseif change.hasEvent("DELETED")>
                <#if from==to>
                    <@l10n>
                        ${time}，您在 <span style="${bold}">${issue.project.name}</span> 项目中删除了一个问题。
                    </@l10n>
                <#else>
                    <@l10n>
                        ${time}，<span style="${bold}">${from.getVisibleName()}</span> 在 <span style="${bold}">${issue.project.name}</span> 项目中删除了一个问题。
                    </@l10n>
                </#if>
            <#else>
                <@l10n>
                    ${time}，<span style="${bold}">${from.getVisibleName()}</span> 限制了对某个问题的访问。
                </@l10n>
            </#if>
        <#else>
            <#if from==to>
                <#if type?has_content>
                    <@l10n>
                        <span style="${bold}">您</span>在 ${time} 更新了 ${issue.project.name} 项目中的
                        <span style="${issueTypeStyle}">${type}</span>。
                    </@l10n>
                <#else>
                    <@l10n>
                        <span style="${bold}">您</span>在 ${time} 更新了 ${issue.project.name} 项目中的
                        <span style="${issueTypeStyle}">问题</span>。
                    </@l10n>
                </#if>
            <#else>
                <#if type?has_content>
                    <@l10n>
                        <span style="${bold}">${from.getVisibleName()}</span> 在 ${time} 更新了 ${issue.project.name} 项目中的
                        <span style="${issueTypeStyle}">${type}</span>。
                    </@l10n>
                <#else>
                    <@l10n>
                        <span style="${bold}">${from.getVisibleName()}</span> 在 ${time} 更新了 ${issue.project.name} 项目中的
                        <span style="${issueTypeStyle}">问题</span>。
                    </@l10n>
                </#if>
            </#if>
        </#if>
    </div>
</#escape>