<#ftl attributes={"description":"Overview of the issue update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign priority = issue.Priority>
    <#assign isShowStopper = (!priority?is_enumerable && priority == "Show-stopper")>
    <#if change.hasEvent("CREATED")>
        <#if (!priority?is_enumerable && priority == "Show-stopper")>
            <@l10n>${issue.reporter.getVisibleName()} 报告了一个新的紧急问题：</@l10n>
        <#else>
            <@l10n>${issue.reporter.getVisibleName()}报告了一个新问题：</@l10n>
        </#if>
    <#elseif last_notification?has_content && last_notification>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("PROJECT")>
            <#if from == to>
                <@l10n>
                    ${time}，您将一个问题移动到您无权读取问题的项目中。
                </@l10n>
            <#else>
                <@l10n>
                    ${time}，${from.getVisibleName()} 将一个问题移动到您无权读取问题的项目中。
                </@l10n>
            </#if>
        <#elseif change.hasEvent("PERMITTED")>
            <#if from == to>
                <@l10n>
                    ${time}，您将一个问题的可见范围限制为您不属于的一组用户。
                </@l10n>
            <#else>
                <@l10n>
                    ${time}，${from.getVisibleName()} 将一个问题的可见范围限制为您不属于的一组用户。
                </@l10n>
            </#if>
        <#elseif change.hasEvent("DELETED")>
            <#if from == to>
                <@l10n>
                    ${time}，您在 ${issue.project.name} 项目中删除了一个问题。
                </@l10n>
            <#else>
                <@l10n>
                    ${time}，${from.getVisibleName()} 在 ${issue.project.name} 项目中删除了一个问题。
                </@l10n>
            </#if>
        <#else>
            <@l10n>
                ${time}，${from.getVisibleName()} 限制了对某个问题的访问。
            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <#if isShowStopper>
                <@l10n>您更改了紧急问题：</@l10n>
            <#else>
                <@l10n>您更改了问题：</@l10n>
            </#if>
        <#else>
            <#if isShowStopper>
                <@l10n>用户 ${from. from.getVisibleName()} 更改了紧急问题：</@l10n>
            <#else>
                <@l10n>用户 ${from.getVisibleName()} 更改了问题：</@l10n>
            </#if>
        </#if>
    </#if>
</p>
</#escape>