<#escape x as x?html>
<html>
    <#import "styles.ftl" as styles>
    <table style="${styles.table} margin: 16px 0;">
        <tr>
            <td style="width: ${styles.icon_width}px;
                       padding: 0;
                       vertical-align: top;">
                <div style="padding: 2px 0 0 14px;">
                        <#include "icon_warning.ftl">
                </div>
            </td>
            <td style="padding: 0; vertical-align: top;">
                <div style="${styles.overview_text}">
                    <@l10n>
                        ${vcsChange.humanReadableDate}，Youtrack 处理了由 <b>${vcsChange.userName}</b> 提交的 VCS 变更。该提交消息包                        含引用 ${issue.project.name} 项目中某个问题的命令。不过，该命令无效。引用的问题未更新。
                    </@l10n>
                    <br/>
                    <br/>
                    <#list vcsChange.commandExecutionInfos as error>
                        <#if error.errorText?has_content>
                            <#noescape>${error.errorText}</#noescape><br/>
                        </#if>
                    </#list>
                    <br/>
                    <br/>
                    <@l10n>
                        要更新问题，请点击此消息中的链接，在 YoutTrack 中打开问题，并手动应用所需的更改。
                    </@l10n>
                </div>
            </td>
        </tr>
    </table>

    <#include "issue_header.ftl">

    <div style="margin-top: 16px">
        <table style="${styles.table} background: #f0f0f0;">
            <tr>
                <td style="${styles.event_title};">
                    <img src="${Utils.getAvatarUrl(vcsChange.user)}"
                         alt="${vcsChange.user.getVisibleName()}"
                         width="24"
                         height="24"/>
                </td>

                <td style="padding: 12px 0;">
                    ${vcsChange.text}
                </td>
                <td style="padding: 12px 16px;">
                    <a title="${issue.project.name}"
                       style="color: #1466c6; float: right;"
                       href="${vcsChange.changeUrl}">
                        ${vcsChange.version}
                    </a>
                </td>
            </tr>
        </table>
    </div>
    <div style="margin-left: ${styles.icon_width}px; padding: 4px 0 8px;">
        <#include "vcs_failure_footer.ftl">
    </div>
</html>
</#escape>