<#escape x as x?html>
<html>
    <#import "styles.ftl" as styles>

    <table style="${styles.table} margin: 16px 0;">
        <tr>
            <td style="width: ${styles.icon_width}px;
                       padding: 0;
                       vertical-align: top;">
                <div style="padding: 2px 0 0 14px;">
                    <#include "icon_warning.ftl">
                </div>
            </td>
            <td style="padding: 0; vertical-align: top;">
                <div style="${styles.overview_text}">
                    <@l10n>
                        ${vcsChange.humanReadableDate}，Youtrack 处理了一个由 VCS 用户 <b>${vcsChange.userName}</b> 应用的变更。
                        该提交消息包含引用 ${issue.project.name} 项目中某个问题的命令。
                        不过，引用的问题由于以下原因未更新：
                    </@l10n>
                        <br/>
                    <#assign noUserReason = vcsChange.noUserReason>
                    <#if noUserReason?has_content>
                        ${noUserReason}
                    <#else>
                        <@l10n>由于未知原因，YoutTrack 无法找到与更改作者匹配的用户帐户。</@l10n>
                    </#if>
                </div>
            </td>
        </tr>
    </table>

    <#include "issue_header.ftl">

    <div style="margin-top: 16px">
        <table style="${styles.table} background: #f0f0f0;">
            <tr>
                <td style="${styles.event_title};">
                    <#include "icon_cross.ftl">
                </td>
                <td style="padding: 12px 0;">
                    ${vcsChange.text}
                </td>
                <td style="padding: 12px 16px;">
                    <a title="${issue.project.name}"
                       style="color: #1466c6; float: right;"
                       href="${vcsChange.changeUrl}">
                        ${vcsChange.version}
                    </a>
                </td>
            </tr>
        </table>
    </div>
    <div style="margin-left: ${styles.icon_width}px; padding: 4px 0 8px;">
	    <#include "vcs_failure_footer.ftl">
    </div>
</html>
</#escape>